/*
*      NAME:   dup
*
*      FUNCTION: duplicate a file handle
*
*      USAGE:  int dup(fd)
*
*      ARGUMENTS:  int fd;
*
*      RETURNS:        Failure or the duplicate file descriptor.
*		       -1 for any OS other than PCDOS 2.0
*
*      REVISION HISTORY:
*		Created by AS on may 3, 84
*		Changed blk*() to mem*() whf 2/85
*		Replaced conditional compile expressions 2/85 JC
*		Moved pcdos2 code to dos2.c 3/85 JC
*
*/

#include "portab.h"
#include "osif.h"
#if PC1OR2
#include "osiferr.h"
#include "osattr.h"
#include "osifx.h"

int
dup(fd)
int fd;					/* file descriptor	  */
{
	REG FD *fp, *ch;
	REG int ich;

	if (!os_unixlike) 
		return(FAILURE);		/* -1 for all other OS */

	if ((fp = _chkc(fd)) == NULLFD)		/* Get CCB address	  */
		return(FAILURE); 		/* Can't EBADF            */
	if (( ich = _allocc()) == FAILURE)	/* Allocate a channel	  */
		return(FAILURE); 		/*   Can't:               */
	__chinit(ich);				 /* clear out channel's ccb*/
	ch = _getccb(ich);			/* get channel address	  */
	if((fd = dos2dup(fd)) == FAILURE)
		return(FAILURE);
	memcpy(ch,fp,sizeof(FD));		/* Copy the old ccb to new*/
	ch -> fd = fd;	 			/* Adjust the file des field*/
	return(ich);				/* return index to FD	  */
}
#endif

       