
/*
 *	NAME:	exit
 *
 *	FUNCTION:
 *		The exit function is called from anywhere to pass control back to
 *		the CCP from the executing C program.
 *		Note that the stream files are closed via '_cleanup()'.
 *
 *	USAGE:
 *		VOID  exit(code)
 *
 *	ARGUMENTS:
 *		code	Is the exit status (ignored)
 *
 *	RETURNS: none
 *
 *		replaced exit4 with dos2exit, removed exit1 3/85 JC
 *	       Modified to wrok on PCDOS 2.0  AS april-11-84
 *		Replaced conditional compiled expressions 2/85 JC
 *		Split into separate files for pcdosb 12/84 JC
*/
#include "portab.h"
#include "osif.h"
#if CPMXPC1

VOID
exit(code)				/* CLEAR FUNCTION ***********/
int	code;				/* Exit status		   */
{
	_cleanup();
	_exit(code);
}
#endif

#if PC2ONLY

VOID
exit(code)				/* CLEAR FUNCTION ***********/
int	code;				/* Exit status		   */
{
	_cleanup();
	dos2exit(code);
}
#endif

#if PCBOTH
#include	"osattr.h"
VOID
exit(code)				/* CLEAR FUNCTION ***********/
int	code;				/* Exit status		   */
{
	_cleanup();
	if(os_unixlike)
		dos2exit(code);
	else
		_exit(code);
}
#endif
                                             