
/*
*
*	NAME:	(Start Off routine) MAIN.C
*
*	FUNCTION:
*		Routine "_main" is entered from the C header routine to start a C
*		program.  It opens STDIN, STDOUT and STDERR to the console, and
*		translates the command line to lower case.  Then it calls "__main()".
*		There are two versions of "__main()" (one compiled for wildcards
*		and the other compiled without) compiled from the source module
*		"XMAIN.C".
*
*	USAGE:
*		_main(command,length)
*
*	ARGUMENTS:
*	  char	*command	Is the address of the command line from CP/M
*	  int	length		Is the number of characters in the line,
*				excluding the termination character (CR/LF).
*
*	REVISION HISTORY:
*		Modfications:
*			11-Oct-83 whf  converted to DRC from CPM68K
*			11-Apr-84 AS   Modified to work on PCDOS 2.0
*			April-84 AS    Dynamic checking for PCDOS versions
*			12/84		Split into separate files JC
*			2/85	JC	Replaced conditional compiled expr
*/

#include "portab.h"
#include "osif.h"                               /*                          */
#if CPMXPC1

_main(com, len) 				/****************************/
	char	*com;				/* Command address	    */
	int	len;				/* Command length	    */
{						/****************************/
	_main1(com,len);
}
#endif

#if PC2ONLY

_main(com, len) 				/****************************/
	char	*com;				/* Command address	    */
	int	len;				/* Command length	    */
{						/****************************/
	_main4(com,len);
}
#endif

#if PCBOTH
#include "osattr.h"
_main(com, len) 				/****************************/
	char	*com;				/* Command address	    */
	int	len;				/* Command length	    */
{						/****************************/
	if(os_unixlike)
		_main4(com,len);
	else
		_main1(com,len);
}
#endif
                          