
/*
*	USAGE:
*		_main(command,length)
*
*	ARGUMENTS:
*	  char	*command	Is the address of the command line from CP/M
*	  int	length		Is the number of characters in the line,
*				excluding the termination character (CR/LF).
*
*	REVISION HISTORY:
*		Modfications:
*			11-Oct-83 whf  converted to DRC from CPM68K
*			11-Apr-84 AS   Modified to work on PCDOS 2.0
*			April-84 AS    Dynamic checking for PCDOS versions
*
*/

#include "portab.h"                             /* Include std definitions  */
#include "osif.h"                               /*                          */
#if PCDOS2

#include "ctype.h"                              /*                          */
#include "osiferr.h"

EXTERN	BYTE	__fdecls();			/* force loading of _iob    */
EXTERN	int	___atab();			/* force loading of ___atab */

_main4(com, len) 				/****************************/
	char	*com;				/* Command address	    */
	int	len;				/* Command length	    */
{						/****************************/
REG	BYTE	*s;				/* Temp byte pointer	    */
	WORD	i;				/* Temp counter 	    */
	FD	*ch;				/* Temp CCB		    */
	FD	*_challoc();			/*			    */

	_chinit();				/* Initialize channels	    */

	ch = _challoc(0);			/* Initialize CCB for STDIN   */
	ch -> flags |= ISREAD | OPENED | ISTTY | ISASCII;
	for ( i = 1 ; i <= 2 ; i++) {
	    ch = _challoc(i);			/*  Allocate Channel 1,2      */
	    ch -> flags |=  ISTTY | OPENED | ISASCII;
	}
	ch = _challoc(3);			/* Initialize CCB for STDAUX  */
	ch -> flags |= ISAUX ;			/* Set Flag for Auxiliary d   */

	ch = _challoc(4);			/* Initialize CCB for STDLPT  */
	ch -> flags |= ISLPT ;			/* Set Flag for std. printer  */
	lseek(0,0L,0);				/* Seek to the begining       */

	com[len] = NULL;			/* Insure null at line end  */
	for (s = com; *s; s++)			/* Convert string to	    */
		*s = tolower(*s);		/*	    lower case	    */
	__main(com,len);			/* Do rest (replaceable)    */
}						/****************************/
#endif
                                                        