/*
 *	NAME:	read
 *
 *	FUNCTION:
 *		The read function simulates the UNIX read system call.	Any
 *		arbitrary number of bytes may be read at any arbitrary offset in
 *		the file.
 *		The terminal handler for read has been set up to simulate some of
 *		the functions provided by "ioctl".
 *
 *	USAGE:
 *		 int read(fd,buffer,bytes)
 *
 *	ARGUMENTS:
 *		int	fd	Is an open file descriptor
 *		char * buffer	Is the buffer address
 *		unsigned int  bytes	Is the number of bytes to read
 *
 *	RETURNS:
 *		number of bytes actually read
 *
 *	REVISION HISTORY:
 *		Replaced conditional compiled expressions 2/85 JC
 *		Modifications for PCDOS 2.0 april,84  AS
 *		Split into separate files for PCDOSB
 *
 *	COMPILER OPTIONS: pcdos (for 1.1) or pcdos2 (for 2.0).
*/
#include "portab.h"
#include "osif.h"

#if CPMXPC1
int	read(fd,buff,bytes)			/* CLEAR FUNCTION ***********/
	int	fd;				/* File descriptor	    */
	char	*buff;				/* -> buffer start	    */
	unsigned int	bytes;			/* =  byte count to read    */
{						/****************************/
	int	_read1();

	return(_read1(fd, buff, bytes));
}
#endif
#if PC2ONLY
int	read(fd,buff,bytes)			/* CLEAR FUNCTION ***********/
	int	fd;				/* File descriptor	    */
	char	*buff;				/* -> buffer start	    */
	unsigned int	bytes;			/* =  byte count to read    */
{						/****************************/
	int	_read4();

	return(_read4(fd, buff, bytes));
}
#endif
#if PCBOTH
#include	"osattr.h"
int	read(fd,buff,bytes)			/* CLEAR FUNCTION ***********/
	int	fd;				/* File descriptor	    */
	char	*buff;				/* -> buffer start	    */
	unsigned int	bytes;			/* =  byte count to read    */
{						/****************************/
	int	_read4(), _read1();

	if(os_unixlike)
		return(_read4(fd, buff, bytes));
	else
		return(_read1(fd, buff, bytes));
}
#endif
                                                                  