
/*
 *
 *	NAME:	read4 -> does read for PCDOS2
 *
 *	USAGE:
 *		 int read(fd,buffer,bytes)
 *
 *	ARGUMENTS:
 *		int	fd	Is an open file descriptor
 *		char * buffer	Is the buffer address
 *		unsigned  bytes	Is the number of bytes to read
 *
 *	RETURNS:
 *		number of bytes actually read
 *
 *	REVISION HISTORY:
 *              Modifications for GEMDOS 18-Mar-85 gmh
 *		Modifications for PCDOS 2.0 april,84  AS
 *		Split into separate files 12/84 JC
 *
*/

#include "portab.h"
#include "osif.h"
#if PCDOS2

#include "osiferr.h"
#include "errno.h"
#include "osattr.h"

int
_read4(fd,buff,bytes)			/* CLEAR FUNCTION ***********/
int	fd;				/* File descriptor	    */
char	*buff;				/* -> buffer start	    */
unsigned int	bytes;			/* =  byte count to read    */
{					/****************************/
REG	FD	*fp;				/* -> ccb to read from	    */
	FD	*_chkc();			/* Converts fd to fp	    */
	int	_ttyin();			/* Read from tty rtn	    */
	int	_rdasc();			/* Read ascii rtn	    */
	int	dos2read();			/* Read binary rtn	    */
						/****************************/
	if((fp=_chkc(fd)) == NULLFD)		/* File open & OK??	    */
		return(FAILURE);		/*	No: EBADF	    */
	if((fp->flags & ATEOF) != 0)		/* End of file already?     */
		return(0);			/* Yes, quit now	    */
	if((fp->flags & ISLPT) != 0)		/* A wise guy?? 	    */
		RETERR(FAILURE,EBADF);		/*	A wise guy!!	    */
#if !GEMDOS
	if (( fp->fd == STDIN ) &&		/* Is the input from the    */
	   ((dos2ioctl(fd,-1,NULLPTR,0,IOGDEV) & ISDEV)  != 0))
						/*  consol?		    */
		return(_ttyin(fp,buff,bytes));	/* Read one line at a time  */
#endif
	if(fp->flags & ISASCII) 		/* ASCII??		    */
		return(_rdasc(fp,buff,bytes));	/* Yes, read ascii	    */
	else	return(dos2read(fp->fd,buff,bytes));/* No, read binary	    */
}
#endif

                                                                                                