/* setvbuf - assign buffering to a stream
**
** Arguments:
**	stream - file pointer to a file that has been opened but not
**		 read or written.
**	buf    - if this is not null, then it points to the array to
**		 be used for buffering.
**	type   - determines how stream will be buffered
**		 _IOFBF - fully buffered
**		 _IOLBF	- line buffered; output is flushed when newline
**			  is written, buffer is full or input requested.
**		 _IONBF - non buffered
**	size   - size of buffer to be used.
**
**	If I/O is non-buffered, buf and size are ignored.
** Return:
**	0 - success
**	nonzero - illegal type or size provided.
*/
#include	"stdio.h"
int
setvbuf(stream, buf, type, size)
FILE	*stream;
BYTE	*buf;
WORD	type;
WORD	size;
{
	/* stream has already been read or written */
	if(stream->_base != NULL)
		return(-1);

	/* non-buffered, just set flag & ignore other args */
	if(type == _IONBF)
	{
		stream->_flag = (stream->_flag & ~_IOLBF) | _IONBF;
		return(0);
	}
	else
	/* either line buffered or fully buffered */
	if(type == _IOLBF || type == _IOFBF)
	{
		/* if its buffered, size has to be > 0 */
		if(size <= 0)
			return(-1);
	}
	else
	/* type unknown */
		return(-1);

	/* it's either line or fully buffered, set up struct accordingly */
	stream->_bsze = size;
	stream->_base = stream->_ptr = buf;
	stream->_flag |= type;
	/* turn off any conflicting flag values */
	if(type == _IOLBF)
		stream->_flag &= ~(_IONBF | _IOFBF);
	else
		stream->_flag &= ~(_IONBF | _IOLBF);
	return(0);
}
                                                                                                             