/*************************************************************************
*
*			stty / gtty   Functions
*			-----------------------
*	Copyright 1983 by Digital Reserach Inc.  All rights reserved.
*
*	"stty(fd,argp)" sets the bits for CON: file opened on 'fd'
*	"gtty(fd,argp)" gets the bits for CON: file opened on 'fd'
*
*	Where:
*		fd  = file descriptor returned by 'open'
*		argp pts to struct 'sgttyb' (see "sgtty.h")
*
*	Rev:
*		2/85 JC replaced conditional compiled expressions
**************************************************************************/
#include "portab.h"
#include "osif.h"
#include "sgtty.h"

int
stty(fd,argp)				/* CLEAR FUNCTION ***********/
int fd;					/* opened file descriptor */
struct sgttyb *argp;			/* ptr to control info */
{
#if CPMPC1
	REG FD *fp; FD *_chkc();

	if( (fp=_chkc(fd)) == NULLFD  ||
	    (fp->flags & ISTTY) == 0  )
		return -1;
	blkmove(argp,&(fp->fcb),sizeof(*argp));	/* no checks: do whatever */
#endif
	return 0;
}


int
gtty(fd,argp)				/* CLEAR FUNCTION ***********/
int fd;					/* opened file descriptor */
struct sgttyb *argp;			/* ptr to control info */
{
#if CPMPC1
	REG FD *fp; FD *_chkc();

	if( (fp=_chkc(fd)) == NULLFD  ||
	    (fp->flags & ISTTY) == 0  )
		return -1;
	blkmove(&(fp->fcb),argp,sizeof(*argp));	/* no checks: do whatever */
#endif
	return 0;
}
                               