 /*********************************************************************
 *		STRFNS.C - a collection of string functions
 *
 *    STRCAT  -  concatenate strings
 *    STRCMP  -  compares strings
 *    STRCPY  -  copies from one string to another
 *    STRLEN  -  finds the number of non-null characters in s.
 *    STRNCAT  -  concatenate strings (limited)
 *    STRNCMP  -  compares strings up to n chars
 *    STRNCPY  -  copies at most n chars from one string to another
 *    STRCHR -  returns a pointer to the first occurence of char in string
 *    STRRCHAR -  returns a pointer to last occurrence of char in string.
 *
 *	Revisions:
 *		Pulled several fns together 2/85 whf
 *		Added strchr 3/85 JC
 *********************************************************************/

#include "portab.h"

/****************************************************************************
*    STRCAT  -  concatenate strings
*
*	BYTE *strcat(s1,s2)	copies s2 to end of s1
*	BYTE *s1, *s2;
*
*	Assumes null terminated strings. No check is made for string area
*		overflow.
****************************************************************************/

BYTE *	strcat(s1,s2)				/* CLEAR FUNCTION ***********/
	BYTE *s1;
REG	BYTE *s2;
{
REG	BYTE *cp;

	for( cp=s1; *cp; cp++ )		/* save s1 for return.		*/
		;
	while( (*cp++ = *s2++) )	/* copy until eos(s2).		*/
		;
	return(s1);
}

 
 /*********************************************************************
 *    STRCMP  -  compares strings
 *
 *	WORD strcmp(s1,s2)
 *	BYTE *s1, *s2;
 *
 *	'strcmp' compares null terminated strings s1 and s2.
 *	Returns:
 *		strcmp < 0  if  s1<s2
 *		strcmp = 0  if  s1=s2
 *		strcmp > 0  if  s1>s2
 *********************************************************************/
 
 
 int	strcmp(s1,s2)				/* CLEAR FUNCTION ***********/
 REG	BYTE *s1, *s2;
 {
 	for(  ;  (*s1 && *s2) && (*s1 == *s2) ;    ++s1, ++s2 )
 		;
 	return((int) *s1 - *s2);
 }
 

/**********************************************************************
*   STRCPY  -  copies from one string to another
*
*	BYTE *strcpy(s1,s2)
*	BYTE *s1, *s2;
*
*	Copies bytes from s2 to s1, stopping after null has been moved.
*	Returns s1.
*	No check for overflow of s1.
***********************************************************************/

BYTE *	strcpy(s1,s2)				/* CLEAR FUNCTION ***********/
	BYTE *s1;
REG	BYTE *s2;
{	REG BYTE *cp;

	cp = s1;			/* save for return.		*/
	while( *cp++ = *s2++ ) 		/* isn't C fun?			*/
		;
	return(s1);
}


 
 /**********************************************************************
 *    STRLEN  -  finds the number of non-null characters in s.
 *
 *	WORD strlen(s)
 *	BYTE *s;
 **********************************************************************/
 
 int	strlen(str)				/* CLEAR FUNCTION ***********/
 REG	BYTE *str;
 {
 REG	BYTE *p;
 	for( p = str; *p; p++ )		/* advance *p until NULL.	*/
 		;
 	return((int)p-str);
 }
 
 
 
 
 /****************************************************************************
 *  STRNCAT  -  concatenate strings (limited)
 *
 *	BYTE *strncat(s1,s2,n)
 *	BYTE *s1, *s2; WORD n;
 *
 *	'strncat' copies at most n bytes of s2 onto the end of s1.
 *
 *	Assumes null terminated strings. No check is made for string area
 *		overflow.
 ****************************************************************************/
 
 BYTE *	strncat(s1,s2,num)			/* CLEAR FUNCTION ***********/
 	BYTE *s1;
 REG	BYTE *s2;			/* 'n' unsigned: if n<0, we'll	*/
 	int  num;			/*  still decrement to 0.	*/
 {
 	REG BYTE *cp;
 
 	for( cp=s1; *cp; cp++)		/* save s1 for return.		*/
 		;
 	while( *s2 && num-- > 0 )	/* copy until eos(s2) or n==0:	*/
 		*cp++ = *s2++;		/*  no copy if n==0.		*/
 	*cp = NULL;			/* make sure string gets eos.	*/
 	return(s1);
 }
 
 
 
 /*********************************************************************
 *    STRNCMP  -  compares strings up to n chars
 *
 *	WORD strncmp(s1,s2,n)
 *	BYTE *s1, *s2;
 *	UWORD n;
 *
 *	'strncmp' compares null terminated strings s1 and s2, and examines
 *	  at most n chars.
 *	Always compares at least 1 char.
 *	n < 0 compares many, many characters.
 *	Returns:
 *		strncmp < 0  if  s1<s2  (within n chars)
 *		strncmp = 0  if  s1=s2	   "    "   "
 *		strncmp > 0  if  s1>s2     "    "   "
 *********************************************************************/
 
 int	strncmp(s1,s2,num)			/* CLEAR FUNCTION ***********/
 REG	BYTE *s1, *s2;
 REG	WORD num;
 {	
 	for( ; --num > 0  &&  (*s1 == *s2); s1++, s2++ )
 		if( *s1 == NULL )
 			return(0);
 	return((int) *s1 - *s2);
 }
 
 
 /**********************************************************************
 *   STRNCPY  -  copies at most n chars from one string to another
 *
 *	BYTE *strcpy(s1,s2,n)
 *	BYTE *s1, *s2;
 *	UWORD n;
 *
 *	Copies at most n bytes from s2 to s1, stopping after null 
 *	  has been moved.
 *	Truncates or null-pads s2, depending on n.
 *	Returns s1.
 *	No check for overflow of s1.
 ***********************************************************************/
 
 
 BYTE *	strncpy(s1,s2,num)			/* CLEAR FUNCTION ***********/
 	BYTE *s1;
 REG	BYTE *s2;
 	int  num;
 {	REG BYTE *cp;
 
 	for( cp=s1; num-- > 0 && (*cp = *s2); cp++,s2++ ) /* isn't C fun?   */
 		;
 	num++;				/* bump n back up.		*/
 	while( num-- )			/* while #chars != 0		*/
 		*cp++ = NULL;		/*   null pad.			*/
 	return(s1);
 }
 


/*********************************************************************
*   STRRCHAR -  returns a pointer to last occurrence of char in string.
*
*	BYTE *strrchr(s,c)
*	BYTE *s, c;
*
*	Like 'strchr', only returns pointer to last c in s (instead of first),
*	  or zero if c not in s.
*
*	Edits:
*	1/84 whf	change from 'rindex()' to 'strchr()'
**********************************************************************/

BYTE *	strrchr(str,ch)				/* CLEAR FUNCTION ***********/
REG	BYTE *str, ch;
{
	REG BYTE *t;

	for( t=str; *t; t++ )		/* look for eos.		*/
		;
	for( ; ch != *t ; t-- )		/* look for c in s.		*/
		if( t==str )		/* if we get to start of string,*/
			return(NULL);	/*   too far.			*/
	return(t);			/* found c. note that 'rindex'	*/
					/*   works (ie. returns eos)	*/
					/*   if c==NULL.		*/
}

BYTE *	rindex(str,ch)				/* CLEAR FUNCTION ***********/
REG	BYTE *str, ch;
{
	return strrchr(str,ch);		/* 'jacket' rtn for V7 compatability*/
}

/*********************************************************************
*   STRCHR -  returns a pointer to first occurrence of char in string.
*	(formerly known as "index()")
*
*	BYTE *strchr(s,c)
*	BYTE *s, c;
*
*	Returns pointer to first c in s, or zero if c not in s.
*
*	Edits:
*	1/84 whf	changed from 'index()' to 'strchr()'
**********************************************************************/

BYTE *	strchr(str,ch)				/* CLEAR FUNCTION ***********/
REG	BYTE *str, ch;
{
	for( ; ch != *str ; str++ )	/* look for c in s.		*/
		if( *str == NULL )	/* if we get to eos, we've gone */
			return(0);	/*   too far.			*/
	return(str);			/* found c. note that 'index'	*/
					/*   works to find NULL, (ie.	*/
					/*   eos), if c==NULL.		*/
}

BYTE *	index(str,ch)				/* CLEAR FUNCTION ***********/
REG	BYTE *str, ch;
{
	return strchr(str,ch);		/* index is jacket rtn for V7...    */
}
                                