#include	"portab.h"
#include	"osif.h"
#include	"osifx.h"
#include	"time.h"

/* time  --> get system time in # of secs since 1/1/70
**
**	Arg -> if the argument is not null it should be a pointer
**		to a long where the time will be returned.  If it
**		is null, the time is just returned as a return value.
**
**	Ret -> (long) current system time as # of secs since 1/1/70
**
**	REV:
**		replaced conditional compiled expressions
*/
LONG
time(trtn)
LONG	*trtn;		/* return time here if not NULL */
{
#if CPM
	struct	{			/* way CPM does it */
		WORD	d_78;		/* # of days since 1/1/78 */
		BYTE	hr;		/* hour in bcd format */
		BYTE	min;		/* min in bcd format */
		} systm;		/* sec is a return val from sys call */
#endif

	BYTE	rsec;		/* secs returned from CPM sys call */

	WORD	daysinyr;

	LONG	tsecs;		/* total seconds */
	LONG	nsec70();	/* converts tm struct to total # of secs */
	WORD	bcd();		/* converts bcd # to int */

	struct	tm	_t,	*tp;	/* tm struct (time.h) */

	tp = &_t;
	/* get system's idea of time and set it up as sec (0-59), min (0-59),
	** hr (0-23), monthday (1-31), mon (0-11), year (year-1900),
	** yday (0-365)
	*/
#if CPM
	rsec = __BDOS(105, &systm);
	tp->tm_sec = bcd(rsec);
	tp->tm_min = bcd(systm.min);
	tp->tm_hour = bcd(systm.hr);
	tp->tm_year = 1978;
	daysinyr = 365 + _isleap(tp->tm_year);
	tp->tm_yday = systm.d_78;
	while(tp->tm_yday > daysinyr)
	{
		tp->tm_yday -= daysinyr;
		++tp->tm_year;
		daysinyr = 365 + _isleap(tp->tm_year);
	}
	monthday(tp->tm_year, tp->tm_yday, &tp->tm_mon, &tp->tm_mday);
#endif
#if PC1OR2
	dos2gdate(&tp->tm_mon, &tp->tm_mday, &tp->tm_year);
	tp->tm_mon -= 1;
	dos2gtime(&tp->tm_hour, &tp->tm_min, &tp->tm_sec);
	yrday(tp->tm_year, tp->tm_mon, tp->tm_mday, &tp->tm_yday);
#endif
	/* adjust to correct for tp structure */
	--tp->tm_yday;
	tp->tm_year -= 1900;
	tsecs = nsec70(tp);
	if(trtn != NULL)
		*trtn = tsecs;
	return(tsecs);
	
}

/* bcd - convert a bcd # to an integer */
WORD
bcd(no)
BYTE	no;
{
	return((no & 0x0f) + (((no >> 4) & 0x0f))*10);
}


/* nsec70 -> given a pointer to a filled in tm structure, convert this
**		data to the # of seconds since 1/1/70
*/
#define	SYR	31536000L	/* sec in year */
#define	SLYR	31622400L	/* sec in leap year */
#define	SDAY	86400L		/* sec in day */

LONG
nsec70(tp)
struct	tm	*tp;
{
	LONG	tsecs = 0L;

	EXTERN	LONG	timezone;
	WORD	dst();			/* need to know if daylight savings */

	--(tp->tm_year);	/* don't want to include current year */
	while(tp->tm_year >= 70)
	{
		/* convert years to seconds */
		if(_isleap(tp->tm_year+1900))
			tsecs += SLYR;
		else
			tsecs += SYR;
		--(tp->tm_year);
	}
	/* add in the rest */
	tsecs += ((tp->tm_yday * SDAY) + (tp->tm_hour * 60L * 60L)
		+ (tp->tm_min * 60L) + tp->tm_sec);
	tsecs += timezone;		/* correct for timezone */
	if(dst(tp))			/* correct for DST */
		tsecs -= 3600L;
	return(tsecs);
}

                                                                                                            