
/*
*
*	NAME:	__main
*
*	FUNCTION:
*		Routine "__main()" is entered from the "_main()" routine
*		to start a C program.  The command string from CP/M is parsed
*		into a UNIX-like "argc/argv" setup, including simple I/O
*		redirection.
*
*		This module can be compiled without wildcard parsing if the
*		symbol "NOWILD" (note upper case) is defined in the compile
*		line.
*
*	USAGE:
*		_main(command,length)
*
*	ARGUMENTS:
*		BYTE	*command   Is the address of the command line from CP/M
*		WORD	lenth	   Is the number of characters in the line,
*				   excluding the termination character (CR/LF).
*
*
*	REVISION HISTORY:
*
*		Edits:
*                       12-Mar-84 gmh  #if'ed out environment for GEMDOS
*			April-84  as   dynamic checking for pcdos versions
*			17-APR-84 as   deleted definitions of STDIN etc.(added
*						    to PORTAB.H
*			02-Feb-84 whf  nowild -> NOWILD, removed write()
*			01-Jan-84 whf  add in handle for OPTION*.h
*			08-Dec-83 whf  handle PC-DOS diffs, add ">>"
*							redirection
*			11-Oct-83 whf  converted to DRC from CPM68K
*
*/


#include "portab.h"                             /* Include std definitions  */
#include "osif.h"                               /* Include CP/M Definitions */

#if PCDOS2

#include "ctype.h"                              /* char type definitions    */
#include "osattr.h"                             /* choose os attributes     */

#define SFNAME	14
#define ISWHITE(ch) ((ch)==NULL || isspace(ch)) /*			    */
#define ENVOFFS 0x2C				/* env offset in psp	    */

#ifndef NOWILD
EXTERN	BYTE	*_salloc();			/* Stack allocation routine */
#endif
EXTERN	BYTE	*sbrk();			/* Incr break location	    */
EXTERN	BYTE	*strchr();			/* V7 "index" function      */
EXTERN	BYTE	__pname[];			/* Default Program name     */
MLOCAL	WORD	argc;				/* Arg count		    */
MLOCAL	BYTE	*argv;				/* -> array of pointers     */
MLOCAL	BYTE	*argv2; 			/* Companion ptr to argv    */
EXTERN	WORD	_getseg();

__main4(com, len)				/****************************/
	BYTE	*com;				/* Command address	    */
	WORD	len;				/* Command length	    */
{						/****************************/
REG	WORD	 i;				/* Define a count var.	    */
REG	BYTE	*s;				/* Temp byte pointer	    */
REG	BYTE	*p;				/* Another ""               */
REG	BYTE	c;				/* Character temp	    */
	BYTE	tmpbuf[128];			/* Filename temp	    */
	BYTE	*strchr();			/* V7 index() func	    */
	WORD	rv;				/* retrun value 	    */
	WORD	pspseg; 			/* psp segment addr	    */
	WORD	envseg; 			/* environ segment addr     */
	WORD	envoff; 			/* environment offset	    */
	WORD	_getpsp();			/* fn for finding psp addr  */
	WORD	lt;				/* length of environ strings*/
	extern int envc;
	extern char *environ;
						/****************************/
	argv2 = argv = sbrk(0); 		/* -> first free location   */
	argc = 0;				/* No args yet		    */
	addargv(__pname);			/*			    */
	for (s = com; *s; s += i)  {		/* One arg at a time	    */
	    while (*s && isspace(*s))		/* Skip leading spaces	    */
			++s;			/*			    */
	    if (!*s)				/* End of line? 	    */
			break;			/* Yes, don't continue      */
	    if(*s == '"' || *s == '\'') {       /* Quoted string            */
		c = *s; 			/* c = quote character	    */
		p = strchr(s+1,c);		/* Find next		    */
		if (p == NULLPTR)		/* Any? 		    */
		    _err(s,": unmatched quote");/* No, bitch.               */
		i = (WORD)p-s;			/* Compute length	    */
		s[i++] = '\0';                  /* Nullify at end           */
		addargv(s+1);			/* Add to arg list	    */
	    }					/****************************/
	    else  {				/*			    */
		for(i = 0; !ISWHITE(s[i]); ++i) /* How many characters?     */
				;		/*			    */
		if (s[i])			/* If last is space, etc... */
		   s[i++] = '\0';               /* Make it a null for C     */

#ifndef NOWILD /*************************************************************/

		if((strchr(s,'?') ||              /* Wild                    */
		       strchr(s,'*')))      {     /*      Cards?             */
		    dos2setdta(tmpbuf);
		    if (( rv = dos2f_file(s,0)) == FAILURE)/* failed ...    */
		       _err(s,": No Match");     /* complain                */
		    while ( rv != FAILURE ) {	 /*  Search for next file   */
		       p = _salloc(SFNAME);	 /*  Allocate area	    */
		       strcpy(p,(tmpbuf+30));	 /*  move in filename	    */
		       addargv(p);		 /*  add this file to argv  */
		       rv = dos2f_next();	 /*  Search next	    */
		    }
		}
		else
#endif /************************************************** no wild ***********/

		     addargv(s);		 /* save in argv	     */
	    }
	}
       addargv(NULLPTR);			/* Insure terminator	    */
       argc--;

#if !GEMDOS /********************** Non-GEMDOS Code ***********************/

       environ = argv2; 			/* init envp		  */
       pspseg = _getpsp();			/* get psp segment addr   */
       movedata(pspseg, ENVOFFS,_getseg(&envseg),/*store the addr of the  */
		     &envseg, sizeof(WORD));	/* environment ptr	  */
       envoff = 0;
       envc = -1;
       do {
	       movedata(envseg, envoff, _getseg(tmpbuf),tmpbuf, 128);
	       lt = strlen(tmpbuf);
	       p  = _salloc(lt + 1);		/* allocate it on the stack*/
	       strcpy(p , tmpbuf);		/* move in environ str	   */
	       addargv(p);			/* add to argv		   */
	       argc--;
	       envc++;
	       envoff += lt + 1;		/* calculate the new offset*/
       } while ( lt > 0 );			/* repeat till null string */
       if( brk(argv2)==FAILURE) 		/* Allocate the pointers    */
		_err("Stack Overflow","");      /* Call "Stack Overflow" rtn*/

#endif /************************** Non-GEMDOS Code **************************/

       exit(main(argc,argv,NULLPTR));		/* Invoke C program (No Env)*/
 }

/*
 *	Addargv function -- adds a pointer to the argv array, getting the
 *	space from the heap.
 */
static addargv(ptr)				/****************************/
REG	BYTE	*ptr;				/* -> Argument string to add*/
{						/*			    */
	*((BYTE **)argv2) = ptr;		/* Load pointer 	    */
	argv2 += sizeof(char *);		/* More room from heap	    */
	argc++; 				/* Increment arg count	    */
}						/****************************/


#endif
                                                                                                                     