/*	DESKAPP.C	06/11/84 - 07/11/85		Lee Lorenzen	*/

/*
*	-------------------------------------------------------------
*	GEM Desktop					  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <dos.h>
#include <deskapp.h>
#include <deskfpd.h>
#include <deskwin.h>
#include <deskdefn.h>
#include <infodef.h>
#include <crysbind.h>
#include <deskbind.h>

#define MIN_WINT 4
#define MIN_HINT 2
						/* in DOS.C		*/
EXTERN LONG		dos_alloc();

EXTERN BYTE		*ini_str();
EXTERN BYTE		*scasb();
EXTERN WORD		wildcmp();

EXTERN WORD		gl_wchar;
EXTERN WORD		gl_hchar;

EXTERN WORD		gl_wschar;
EXTERN WORD		gl_hschar;

EXTERN WORD		gl_width;
EXTERN WORD		gl_height;
EXTERN WORD		gl_wbox;
EXTERN WORD		gl_hbox;
EXTERN WORD		DOS_ERR;
EXTERN UWORD		global[];

EXTERN GLOBES		G;

GLOBAL WORD		gl_pstart;
GLOBAL WORD		gl_poffset;
GLOBAL WORD		gl_numics;

GLOBAL BYTE		gl_afile[SIZE_AFILE];
GLOBAL BYTE		gl_buffer[SIZE_BUFF];
/*
*	Allocate an application object.
*/

	ANODE
*app_alloc(tohead)
	WORD		tohead;
{
	ANODE		*pa, *ptmpa;

	pa = G.g_aavail;
	if (pa)
	{
	  G.g_aavail = pa->a_next;
	  if ( (tohead) ||
	       (!G.g_ahead) )
	  {
	    pa->a_next = G.g_ahead;
	    G.g_ahead = pa;
	  }
	  else
	  {
	    ptmpa = G.g_ahead;
	    while( ptmpa->a_next )
	      ptmpa = ptmpa->a_next;
	    ptmpa->a_next = pa;
	    pa->a_next = (ANODE *) NULL;
	  }
	}
	return(pa);
}


/*
*	Free an application object.
*/

	VOID
app_free(pa)
	ANODE		*pa;
{
	ANODE		*ptmpa;

	if (G.g_ahead == pa)
	  G.g_ahead = pa->a_next;
	else
	{
	  ptmpa = G.g_ahead;
	  while ( (ptmpa) &&
		  (ptmpa->a_next != pa) )
	    ptmpa = ptmpa->a_next;
	  if (ptmpa)
	    ptmpa->a_next = pa->a_next;
	}
	pa->a_next = G.g_aavail;
	G.g_aavail = pa;
}


/*
*	Convert a single hex ASCII digit to a number
*/

	WORD
hex_dig(achar)
	BYTE		achar;
{
	if ( (achar >= '0') &&
	     (achar <= '9') )
	  return(achar - '0');	
	if ( (achar >= 'A') &&
	     (achar <= 'F') )
	  return(achar - 'A' + 10);
	return(0);
}
	

/*
*	Reverse of hex_dig().
*/

	BYTE
uhex_dig(wd)
	WORD		wd;
{
	if ( (wd >= 0) &&
	     (wd <= 9) )
	  return(wd + '0');	
	if ( (wd >= 0x0a) &&
	     (wd <= 0x0f) )
	  return(wd + 'A' - 0x0a);
	return(' ');
}
	

/*
*	Scan off and convert the next two hex digits and return with
*	pcurr pointing one space past the end of the four hex digits
*/

	BYTE
*scan_2(pcurr, pwd)
	BYTE		*pcurr;
	UWORD		*pwd;
{
	UWORD		temp;
	
	temp = 0x0;
	temp |= hex_dig(*pcurr++) << 4;
	temp |= hex_dig(*pcurr++);
	if (temp == 0x00ff)
	  temp = NIL;
	*pwd = temp;
	return(	pcurr );
}

/*
*	Reverse of scan_2().
*/

	BYTE
*save_2(pcurr, wd)
	BYTE		*pcurr;
	UWORD		wd;
{
	*pcurr++ = uhex_dig((wd >> 4) & 0x000f);
	*pcurr++ = uhex_dig(wd & 0x000f);
	return(	pcurr );
}

/*
*	Scan off spaces until a string is encountered.  An @ denotes
*	a null string.  Copy the string into a string buffer until
*	a @ is encountered.  This denotes the end of the string.  Advance
*	pcurr past the last byte of the string.
*/

	BYTE
*scan_str(pcurr, ppstr)
	BYTE		*pcurr;
	BYTE		**ppstr;
{
	while(*pcurr == ' ')
	  pcurr++;
	*ppstr = G.g_pbuff;
	while(*pcurr != '@')
	  *G.g_pbuff++ = *pcurr++;
	*G.g_pbuff++ = NULL;
	pcurr++;
	return(pcurr);
}


/*
*	Reverse of scan_str.
*/

	BYTE
*save_str(pcurr, pstr)
	BYTE		*pcurr;
	BYTE		*pstr;
{
	while(*pstr)
	  *pcurr++ = *pstr++;
	*pcurr++ = '@';
	*pcurr++ = ' ';
	return(pcurr);
}


/*
*	Parse a single line from the DESKTOP.APP file.
*/

	BYTE
*app_parse(pcurr, pa)
	BYTE		*pcurr;
	ANODE		*pa;
{
	switch(*pcurr)
	{
	  case 'T':				/* Trash Can		*/
		pa->a_type = AT_ISTRSH;
		pa->a_flags = AF_ISCRYS | AF_ISGRAF | AF_ISDESK;
		break;
	  case 'M':				/* Storage Media	*/
		pa->a_type = AT_ISDISK;
		pa->a_flags = AF_ISCRYS | AF_ISGRAF | AF_ISDESK;
		break;
	  case 'G':				/* GEM App File		*/
		pa->a_type = AT_ISFILE;
		pa->a_flags = AF_ISCRYS | AF_ISGRAF;
		break;
	  case 'F':				/* DOS File no parms	*/
	  case 'f':				/*   needs full memory	*/
		pa->a_type = AT_ISFILE;
		pa->a_flags = (*pcurr == 'F') ? NONE : AF_ISFMEM;
		break;
	  case 'P':				/* DOS App needs parms	*/
	  case 'p':				/*   needs full memory	*/
		pa->a_type = AT_ISFILE;
		pa->a_flags = (*pcurr == 'P') ? 
				AF_ISPARM : AF_ISPARM | AF_ISFMEM;
		break;
	  case 'D':				/* Directory (Folder)	*/
		pa->a_type = AT_ISFOLD;
		break;
	}
	pcurr++;
	if (pa->a_flags & AF_ISDESK)
	{
	  pcurr = scan_2(pcurr, &pa->a_xspot);
	  pcurr = scan_2(pcurr, &pa->a_yspot);
	}
	pcurr = scan_2(pcurr, &pa->a_aicon);
	pcurr = scan_2(pcurr, &pa->a_dicon);
	pcurr++;
	if (pa->a_flags & AF_ISDESK)
	{
	  pa->a_letter = (*pcurr == ' ') ? NULL : *pcurr;
	  pcurr += 2;
	}
	pcurr = scan_str(pcurr, &pa->a_pappl);
	pcurr = scan_str(pcurr, &pa->a_pdata);
	return(pcurr);
}


app_tran(bi_num)
	WORD		bi_num;
{
	LONG		lpbi;
	BITBLK		lb;

	rsrc_gaddr(R_BITBLK, bi_num, &lpbi);

	LBCOPY(ADDR(&lb), lpbi, sizeof(BITBLK));
	gsx_trans(lb.bi_pdata, lb.bi_wb, lb.bi_pdata, lb.bi_wb, lb.bi_hl);
}


	WORD
app_getfh(openit, pname, attr)
	WORD		openit;
	BYTE		*pname;
	WORD		attr;
{
	WORD		handle;
	LONG		lp;

	handle = 0;
	strcpy(pname, &G.g_srcpth[0]);
	lp = ADDR(&G.g_srcpth[0]);
	if ( shel_find(lp) )
	{
	  if (openit)
	    handle = dos_open(lp, attr);
	  else
	    handle = dos_create(lp, attr);
	  if ( DOS_ERR )
	  {
	    handle = 0;
	  }
	}
	return(handle);
}

/************************************************************************/
/* a p p _ r d i c o n							*/
/************************************************************************/
	WORD
app_rdicon()
{
	LONG		temp, stmp, dtmp;
	WORD		handle, length, ret, i, iwb, ih, fixup, poffset;
	WORD		num_icons, num_masks, last_icon, num_wds, 
			num_bytes, tot_bytes, msk_bytes, tmp;
						/* open the file	*/
	handle = app_getfh(TRUE, 
		ini_str( (gl_height <= 300) ? ST_GEMLICN : ST_GEMHICN), 2);
	if (!handle)
	  return(FALSE);
						/* how much to read?	*/
	length = NUM_IBLKS * sizeof(ICONBLK);
	ret = dos_read(handle, 2, ADDR(&gl_pstart));
	ret = dos_read(handle, 2, ADDR(&poffset));
	poffset += 4 + length;
	gl_pstart -= poffset;
						/* read it		*/
	ret = dos_read(handle, length, ADDR(&G.g_idlist[0]) );
	movs(length, &G.g_idlist[0], &G.g_iblist[0]);
						/* find no. of icons	*/
						/*   actually used	*/
	num_icons = last_icon = 0;
	while ( (last_icon < NUM_IBLKS) &&
		(G.g_idlist[last_icon].ib_pmask != -1L) )
	{
	  tmp = max( LLOWD(G.g_idlist[last_icon].ib_pmask),
		     LLOWD(G.g_idlist[last_icon].ib_pdata) );
	  num_icons = max(num_icons, tmp);
	  last_icon++;
	}
	num_icons++;
						/* how many words of 	*/
						/*   data to read?	*/
						/* assume all icons are	*/
						/*   same w,h as first	*/
	num_wds = (G.g_idlist[0].ib_wicon * G.g_idlist[0].ib_hicon) / 16;
	num_bytes = num_wds * 2;
	tot_bytes = num_icons * num_bytes;
						/* allocate some memory	*/
						/*   in bytes     	*/
	G.a_datastart = dos_alloc( LW(gl_pstart + (NUM_NAMICS*2)) );
						/* read it		*/
	ret = dos_read(handle, gl_pstart+(NUM_NAMICS*2), G.a_datastart);
	dos_close(handle);
						/* fix up str ptrs	*/
	gl_numics = 0;
	for (i=0; i<NUM_NAMICS; i++)
	{
	  fixup = LWGET(G.a_datastart + gl_pstart + (i*2)) - poffset;
	  LWSET((G.a_datastart + gl_pstart + (i*2)), fixup);
	  if (LBGET(G.a_datastart+fixup))
	    gl_numics++;
	}
						/* figure out which are	*/
						/*   mask & which data	*/
	for (i=0; i<last_icon; i++)
	{
	  G.g_ismask[ (WORD) G.g_idlist[i].ib_pmask] = TRUE;
	  G.g_ismask[ (WORD) G.g_idlist[i].ib_pdata] = FALSE;
	}
						/* fix up mask ptrs	*/
	num_masks = 0;
	for (i=0; i<num_icons; i++)
	{
	  if (G.g_ismask[i])
	  {
	    G.g_ismask[i] = num_masks;
	    num_masks++;
	  }
	  else
	    G.g_ismask[i] = -1;
	}
						/* allocate memory for	*/
						/*   transformed mask	*/
						/*   forms		*/
	msk_bytes = num_masks * num_bytes;
	G.a_buffstart = dos_alloc( LW(msk_bytes) );
						/* fix up icon pointers	*/
	for (i=0; i<last_icon; i++)
	{
						/* first the mask	*/
	  temp = ( G.g_ismask[ G.g_idlist[i].ib_pmask ] * ((LONG) num_bytes));
	  G.g_iblist[i].ib_pmask = G.a_buffstart + LW(temp);
	  temp = ( G.g_idlist[i].ib_pmask * ((LONG) num_bytes));
	  G.g_idlist[i].ib_pmask = G.a_datastart + LW(temp);
						/* now the data		*/
	  temp = ( G.g_idlist[i].ib_pdata * ((LONG) num_bytes));
	  G.g_iblist[i].ib_pdata = G.g_idlist[i].ib_pdata = 
		G.a_datastart + LW(temp);
						/* now the text ptrs	*/
	  G.g_idlist[i].ib_ytext = G.g_iblist[i].ib_ytext = 
			G.g_idlist[0].ib_hicon;
	  G.g_idlist[i].ib_wtext = G.g_iblist[i].ib_wtext = 12 * gl_wschar;
	  G.g_idlist[i].ib_htext = G.g_iblist[i].ib_htext = gl_hschar + 2;
	}
						/* transform forms	*/
	iwb = G.g_idlist[0].ib_wicon / 8;
	ih = G.g_idlist[0].ib_hicon;

	for (i=0; i<num_icons; i++)
	{
	  if (G.g_ismask[i] != -1)
	  {
						/* preserve standard	*/
						/*   form of masks	*/
	    stmp = G.a_datastart + (i * num_bytes);
	    dtmp = G.a_buffstart + (G.g_ismask[i] * num_bytes);
	    LWCOPY(dtmp, stmp, num_wds);
	  }
	  else
	  {
						/* transform over std.	*/
						/*   form of datas	*/
	    dtmp = G.a_datastart + (i * num_bytes);
	  }
	  gsx_trans(dtmp, iwb, dtmp, iwb, ih);
	}
	app_tran(0);
	return(TRUE);
} /* app_rdicon */


app_posicon(newx, newy, px, py)
	WORD		newx, newy;
	WORD		*px, *py;
{
	WORD		x, y, w, h;
	WORD		xm, ym;

	w = G.g_icw;
	x = newx / w;
	xm = newx % w;
	if (xm > (w/2))
	  *px = ((x+1) * w);
	else
	  *px = (x * w);
	*px = min(*px, gl_width-w);

	if (*px > (gl_width/2) )
	  *px += (gl_width % w);

	newy -= G.g_ydesk;
	h = G.g_ich;
	y = newy / h;
	ym = newy % h;
	if (ym > (h/2))
	  *py = ((y+1) * h);
	else
	  *py = (y * h);
	*py = min(*py, G.g_hdesk-h);

	if (*py > (G.g_hdesk/2) )
	  *py += (G.g_hdesk % h);
	*py += G.g_ydesk;
}


/*
*	Initialize the application list by reading in the DESKTOP.APP
*	file, either from memory or from the disk if the shel_get
*	indicates no message is there.
*/
	WORD
app_start()
{
	WORD		i;
	ANODE		*pa;
	WSAVE		*pws;
	WORD		flags;
	BYTE		*pcurr, *ptmp;
	WORD		fh, envr, xcnt, ycnt, xcent;
	
	G.g_pbuff = &gl_buffer[0];
	
	for(i=NUM_ANODES - 2; i >= 0; i--)
	  G.g_alist[i].a_next = &G.g_alist[i + 1];
	G.g_ahead = (ANODE *) NULL;
	G.g_aavail = &G.g_alist[0];
	G.g_alist[NUM_ANODES - 1].a_next = (ANODE *) NULL;

	shel_get(ADDR(&gl_afile[0]), SIZE_AFILE);
	if (gl_afile[0] != '#')
	{
						/* invalid signature	*/
						/*   so read from disk	*/
	  fh = app_getfh(TRUE, ini_str(ST_GEMAPP), 0x0);
	  if (!fh)
	    return(FALSE);
	  G.g_afsize = dos_read(fh, SIZE_AFILE, ADDR(&gl_afile[0]));
	  dos_close(fh);
	  gl_afile[G.g_afsize] = NULL;
	}
	

	i = 0;
	pcurr = &gl_afile[0];
	while (*pcurr)
	{
	  if (*pcurr != '#')
	    pcurr++;
	  else
	  {
	    pcurr++;
	    switch(*pcurr)
	    {
	      case 'T':				/* Trash Can		*/
			pa = app_alloc(TRUE);
	      		pcurr = app_parse(pcurr, pa);
						/* rest of standards	*/
			for(i=0; i<6; i++)
		        {
			  pa = app_alloc(TRUE);
	      		  app_parse(ini_str(ST_1STD+i)+1, pa);
			}
			break;
	      case 'M':				/* Media (Hard/Floppy)	*/
	      case 'G':				/* GEM Application	*/
	      case 'F':				/* File	(DOS w/o parms)	*/
	      case 'f':				/*   use full memory	*/
	      case 'P':				/* Parm	(DOS w/ parms)	*/
	      case 'p':				/*   use full memory	*/
	      case 'D':				/* Directory		*/
			pa = app_alloc(TRUE);
	      		pcurr = app_parse(pcurr, pa);
			break;
	      case 'W':				/* Window		*/
			pcurr++;
			pws = &G.g_cnxsave.win_save[i++];
			pcurr = scan_2(pcurr, &pws->hsl_save);
			pcurr = scan_2(pcurr, &pws->vsl_save);
			pcurr = scan_2(pcurr, &pws->x_save);
			pws->x_save *= gl_wchar;
			pcurr = scan_2(pcurr, &pws->y_save);
			pws->y_save *= gl_hchar;
			pcurr = scan_2(pcurr, &pws->w_save);
			pws->w_save *= gl_wchar;
			pcurr = scan_2(pcurr, &pws->h_save);
			pws->h_save *= gl_hchar;
			pcurr = scan_2(pcurr, &pws->obid_save);
			ptmp = &pws->pth_save[0];
			pcurr++;
			while ( *pcurr != '@' )
			  *ptmp++ = *pcurr++;
			*ptmp = NULL;
			break;
	      case 'E':
			pcurr++;
			pcurr = scan_2(pcurr, &envr);
			G.g_cnxsave.vitem_save = ( (envr & 0x80) != 0);
			G.g_cnxsave.sitem_save = ( (envr & 0x60) >> 5);
			G.g_cnxsave.cdele_save = ( (envr & 0x10) != 0);
			G.g_cnxsave.ccopy_save = ( (envr & 0x08) != 0);
			G.g_cnxsave.cdclk_save = envr & 0x07;
			pcurr = scan_2(pcurr, &envr);
			sound(FALSE, !envr, 0);
			break;
	    }
	  }
	}
	if (!app_rdicon())
	  return(FALSE);	
	G.g_wicon = (12 * gl_wschar) + (2 * G.g_idlist[0].ib_xtext);
	G.g_hicon = G.g_idlist[0].ib_hicon + gl_hschar + 2;

	G.g_icw = (gl_height <= 300) ? 0 : 8;
	G.g_icw += G.g_wicon;
	xcnt = (gl_width/G.g_icw);
	G.g_icw += (gl_width % G.g_icw) / xcnt;
	G.g_ich = G.g_hicon + MIN_HINT;
	ycnt = ((gl_height-gl_hbox) / G.g_ich);
	G.g_ich += ((gl_height-gl_hbox) % G.g_ich) / ycnt;
	for (pa=G.g_ahead; pa; pa=pa->a_next)
	{
	  app_posicon(pa->a_xspot * G.g_icw, G.g_ydesk +(pa->a_yspot * G.g_ich), 
			&pa->a_xspot, &pa->a_yspot);
	}
	xcent = (G.g_wicon - G.g_idlist[0].ib_wicon) / 2;
	G.g_nmicon = 9;
	G.g_xyicon[0] = xcent;  G.g_xyicon[1] = 0;
	G.g_xyicon[2]=xcent; G.g_xyicon[3]=G.g_hicon-gl_hschar-2;
	G.g_xyicon[4] = 0;  G.g_xyicon[5] = G.g_hicon-gl_hschar-2;
	G.g_xyicon[6] = 0;  G.g_xyicon[7] = G.g_hicon;
	G.g_xyicon[8] = G.g_wicon;  G.g_xyicon[9] = G.g_hicon;
	G.g_xyicon[10]=G.g_wicon; G.g_xyicon[11] = G.g_hicon-gl_hschar-2;
	G.g_xyicon[12]=G.g_wicon - xcent; G.g_xyicon[13]=G.g_hicon-gl_hschar-2;
	G.g_xyicon[14] = G.g_wicon - xcent;  G.g_xyicon[15] = 0;
	G.g_xyicon[16] = xcent;  G.g_xyicon[17] = 0;
	G.g_nmtext = 5;
	G.g_xytext[0] = 0;  		G.g_xytext[1] = 0;
	G.g_xytext[2] = gl_wchar * 12; 	G.g_xytext[3] = 0;
	G.g_xytext[4] = gl_wchar * 12;   G.g_xytext[5] = gl_hchar;
	G.g_xytext[6] = 0;  		G.g_xytext[7] = gl_hchar;
	G.g_xytext[8] = 0; 		G.g_xytext[9] = 0;
	return(TRUE);
}


/*
*	Reverse list when we write so that we can read it in naturally
*/

app_revit()
{
	ANODE		*pa;
	ANODE		*pnxtpa;
						/* reverse list		*/
	pa = G.g_ahead;
	G.g_ahead = (ANODE *) NULL;
	while(pa)
	{
	  pnxtpa = pa->a_next;
	  pa->a_next = G.g_ahead;
	  G.g_ahead = pa;
	  pa = pnxtpa;
	}
}


/*
*	Save the current state of all the icons to a file called 
*	DESKTOP.APP
*/

app_save(todisk)
	WORD		todisk;
{
	WORD		i, fh, ret, envr, temp;
	BYTE		*pcurr, *ptmp;
	ANODE		*pa;
	WSAVE		*pws;

	bfill(SIZE_AFILE, 0, &gl_afile[0]);
	pcurr = &gl_afile[0];
						/* save evironment	*/
	*pcurr++ = '#';
	*pcurr++ = 'E';
	envr = 0x0;
	envr |= (G.g_cnxsave.vitem_save) ? 0x80 : 0x00;
	envr |= ((G.g_cnxsave.sitem_save) << 5) & 0x60;
	envr |= (G.g_cnxsave.cdele_save) ? 0x10 : 0x00;
	envr |= (G.g_cnxsave.ccopy_save) ? 0x08 : 0x00;
	envr |= G.g_cnxsave.cdclk_save;
	pcurr = save_2(pcurr, envr);

	pcurr = save_2(pcurr, (sound(FALSE, 0xFFFF, 0) ? 0 : 1) );

	*pcurr++ = 0x0d;
	*pcurr++ = 0x0a;
						/* save windows		*/
	for(i=0; i<NUM_WNODES; i++)
	{
	  *pcurr++ = '#';
	  *pcurr++ = 'W';
	  pws = &G.g_cnxsave.win_save[i];
	  pcurr = save_2(pcurr, pws->hsl_save);
	  pcurr = save_2(pcurr, pws->vsl_save);
	  pcurr = save_2(pcurr, pws->x_save / gl_wchar);
	  pcurr = save_2(pcurr, pws->y_save / gl_hchar);
	  pcurr = save_2(pcurr, pws->w_save / gl_wchar);
	  pcurr = save_2(pcurr, pws->h_save / gl_hchar);
	  pcurr = save_2(pcurr, pws->obid_save);
	  ptmp = &pws->pth_save[0];
	  *pcurr++ = ' ';
	  while (*ptmp)
	    *pcurr++ = *ptmp++;
	  *pcurr++ = '@';
	  *pcurr++ = 0x0d;
	  *pcurr++ = 0x0a;
	}		
						/* reverse list		*/
	app_revit();
						/* save anode list	*/
	for(pa=G.g_ahead; pa; pa=pa->a_next)
	{
	  *pcurr++ = '#';
	  switch(pa->a_type)
	  {
	    case AT_ISTRSH:
		*pcurr++ = 'T';
		break;
	    case AT_ISDISK:
		*pcurr++ = 'M';
		break;
	    case AT_ISFILE:
		if ( (pa->a_flags & AF_ISCRYS) &&
		     (pa->a_flags & AF_ISGRAF) )
		  *pcurr++ = 'G';
		else
		{  
		  *pcurr = (pa->a_flags & AF_ISPARM) ? 'P' : 'F';
		  if (pa->a_flags & AF_ISFMEM)
		    *pcurr += 'a' - 'A';
		  pcurr++;
		}
		break;
	    case AT_ISFOLD:
		*pcurr++ = 'D';
		break;
	  }
	  if (pa->a_flags & AF_ISDESK)
	  {
	    pcurr = save_2(pcurr, pa->a_xspot / G.g_icw);
	    pcurr = save_2(pcurr, (pa->a_yspot - G.g_ydesk) / G.g_ich);
	  }
	  pcurr = save_2(pcurr, pa->a_aicon);
	  pcurr = save_2(pcurr, pa->a_dicon);
	  *pcurr++ = ' ';
	  if (pa->a_flags & AF_ISDESK)
	  {
	    *pcurr++ = (pa->a_letter == NULL) ? ' ' : pa->a_letter;
	    *pcurr++ = ' ';
	  }
	  pcurr = save_str(pcurr, pa->a_pappl);
	  pcurr = save_str(pcurr, pa->a_pdata);
	  pcurr--;
	  *pcurr++ = 0x0d;
	  *pcurr++ = 0x0a;
						/* skip standards	*/
	  if (pa->a_type == AT_ISTRSH)
	  {
	    for(i=0; i<6; i++)
	      pa = pa->a_next;
	  }
	}
	*pcurr++ = 0x1a;
	*pcurr++ = 0x0;
						/* reverse list back	*/
	app_revit();
						/* calculate size 	*/
	G.g_afsize = pcurr - &gl_afile[0];
						/* save in memory	*/
	shel_put(ADDR(&gl_afile[0]), G.g_afsize);
						/* save to disk		*/
	if (todisk)
	{
	  G.g_afsize--;
	  fh = 0;
	  while (!fh)
	  {
	    fh = app_getfh(FALSE, ini_str(ST_GEMAPP), 0x0);
	    if (!fh)
	    {
	      ret = fun_alert(1, ST_NOINF, NULLPTR);
	      if (ret == 2)
	        return(FALSE);
	    }
	  }
	  G.g_afsize = dos_write(fh, G.g_afsize, ADDR(&gl_afile[0]));
	  dos_close(fh);
	}
}


/*
*	Build the desktop list of objects based on this current 
*	application list.
*/

	WORD
app_blddesk()
{
	WORD		obid;
	UWORD		bvdisk, bvhard, bvect;
	ANODE		*pa;
	OBJECT		*pob;
	ICONBLK		*pic;
						/* free all this windows*/
						/*   kids and set size	*/
	obj_wfree(DROOT, 0, 0, gl_width, gl_height);
	G.g_screen[DROOT].ob_spec = LW(global[3]) + HW(global[4]);

	bvdisk = bvhard = 0x0;

	for(pa=G.g_ahead; pa; pa=pa->a_next)
	{
	  if (pa->a_flags & AF_ISDESK)
	  {
	    obid = obj_ialloc(DROOT, pa->a_xspot, pa->a_yspot,
					G.g_wicon, G.g_hicon);
	    if (!obid)
	    {
	    /* error case, no more obs */
	    }
						/* set up disk vector	*/
	    if (pa->a_type == AT_ISDISK)
	    {
	      bvect = ((UWORD) 0x8000) >> ((UWORD) (pa->a_letter - 'A'));
	      bvdisk |= bvect;
	      if (pa->a_aicon == IG_HARD)
		bvhard |= bvect;
	    }
						/* remember it		*/
	    pa->a_obid = obid;
						/* build object		*/
	    pob = &G.g_screen[obid];
	    pob->ob_state = NORMAL;
	    pob->ob_flags = NONE;
	    pob->ob_type = G_ICON;
	    G.g_index[obid] = pa->a_aicon;
	    pob->ob_spec = ADDR( pic = &G.g_icons[obid] );
	    movs(sizeof(ICONBLK), &G.g_iblist[pa->a_aicon], pic);
	    pic->ib_xicon = ((G.g_wicon - pic->ib_wicon) / 2);
	    pic->ib_ptext = ADDR(pa->a_pappl);
	    pic->ib_char |= (0x00ff & pa->a_letter);
	  }
	}
	appl_bvset(bvdisk, bvhard);
}


/*
*	Find the ANODE that is appropriate for this object.
*/

	ANODE
*app_afind(isdesk, atype, obid, pname, pisapp)
	WORD		isdesk;
	WORD		atype;
	WORD		obid;
	BYTE		*pname;
	WORD		*pisapp;
{
	ANODE		*pa;

	for(pa=G.g_ahead; pa; pa=pa->a_next)
	{
	  if (isdesk)
	  {
	    if ( pa->a_obid == obid )
	      return(pa);
	  }
	  else
	  {
	    if (pa->a_type == atype)
	    {
	      if ( !(pa->a_flags & AF_ISDESK) )
	      {
	        if ( wildcmp(pa->a_pdata, pname) )
		{
		  *pisapp = FALSE;
		  return(pa);
		}
	        if ( wildcmp(pa->a_pappl, pname) )
		{
		  *pisapp = TRUE;
		  return(pa);
		}
	      }
	    }
	  }
	}
	return(0);
}
