/*	GEMINIT.C	4/23/84 - 07/11/85	Lee Lorenzen		*/
/*	GEMCLI.C	1/28/84 - 05/27/85	Lee Jay Lorenzen	*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 1.0
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>
#include <struct88.h>
#include <baspag88.h>
#include <gemlib.h>
#include <crysbind.h>
#include <gemdefn.h>
#include <dos.h>

/*
*	In an effort to save bytes, the initialization code in this module
*	and in GEMSTART.A86 that precedes this will be overlayed with data.
*	Actually the overlapping of data must stop prior to the call to 
*	sh_main() at the bottom of this module, so we can get back to the 
*	routine that called us.
*/

#define ROPEN 0
#define WOPEN 1
#define RWOPEN 2

#define ARROW 0
#define HGLASS 2

#define PATH_LEN 0x40			/* path length defined by PC_DOS*/

EXTERN LONG	dos_alloc();
						/* in DOSIF.A86		*/
EXTERN		cli();
EXTERN		sti();
EXTERN		takecpm();
EXTERN		givecpm();
						/* in GEMCTRL.C		*/
EXTERN PD	*ictlmgr();
EXTERN PD	*inulmgr();
EXTERN VOID	ctlmgr();
EXTERN VOID	nulmgr();
						/* in SHLIB.C		*/
EXTERN VOID	sh_main();
EXTERN BYTE	*sh_name();
						/* in GEMINIT.C		*/
EXTERN VOID	start();
						/* in PD88.C		*/
EXTERN PD	*getpd();
EXTERN PD	*pstart();
EXTERN PD	*pd_index();
						/* in DISPA88.A86	*/
EXTERN VOID	gotopgm();
						/* in DOSIF.A86		*/
EXTERN VOID	pgmld();
EXTERN WORD	DOS_ERR;
EXTERN LONG	dos_avail();
						/* in GEMRSLIB.C	*/
EXTERN BYTE	*rs_str();

EXTERN GRECT	gl_rscreen;

EXTERN WORD	gl_recd;
EXTERN WORD	gl_rlen;
EXTERN LONG	gl_rbuf;

EXTERN PD	*gl_mowner;
EXTERN PD	*ctl_pd;

EXTERN LONG	ad_scmd;
EXTERN LONG	ad_s1fcb;
EXTERN LONG	ad_s2fcb;
EXTERN LONG	ad_stail;

EXTERN LONG	ad_ssave;
EXTERN LONG	ad_dta;
EXTERN LONG	ad_path;
EXTERN LONG	ad_scrap;
EXTERN LONG	ad_windspb;

EXTERN LONG	ad_tmp1;
EXTERN BYTE	gl_tmp1[];
EXTERN LONG	ad_tmp2;
EXTERN BYTE	gl_tmp2[];
EXTERN LONG	ad_fsdta;
EXTERN WORD	hdr_buff[];
EXTERN LONG	ad_hdrbuff;
EXTERN WORD	intin[];
EXTERN LONG	ad_scdir;

EXTERN LONG	ad_g1loc;
EXTERN LONG	ad_g2loc;

EXTERN LONG	ad_valstr;
EXTERN LONG	ad_tmpstr;
EXTERN LONG	ad_rawstr;
EXTERN LONG	ad_fmtstr;
EXTERN LONG	ad_edblk;
EXTERN LONG	ad_bi;
EXTERN LONG	ad_ib;

EXTERN LONG	ad_fstree;
EXTERN LONG	ad_pfile;
EXTERN GRECT	gl_rfs;

EXTERN TEDINFO	edblk;
EXTERN BITBLK	bi;
EXTERN ICONBLK	ib;

EXTERN WORD	gl_bclick;
EXTERN WORD	gl_bdesired;
EXTERN WORD	gl_btrue;
EXTERN WORD	gl_bdely;

EXTERN LONG	tikaddr;
EXTERN LONG	tiksav;
EXTERN WORD	gl_ticktime;
EXTERN WORD	totpds;				/* 2 if on 256k system,	*/
						/*   else NUM_PDS	*/
EXTERN WORD	sh_intcnt;

EXTERN WORD	gl_dacnt;

EXTERN WORD	gl_nmdisk;
EXTERN WORD	gl_chnlsz;		/* size in bytes of channel	*/
EXTERN WORD	gl_currdsk;

EXTERN WORD	gl_shgem;
EXTERN SHELL	sh[];

EXTERN THEGLO	D;

GLOBAL UWORD	PARABEG;
GLOBAL EVB	evx;

GLOBAL LONG	ad_sysglo;
GLOBAL LONG	ad_armice;
GLOBAL LONG	ad_hgmice;
GLOBAL LONG	ad_mouse;
GLOBAL LONG	ad_envrn;
GLOBAL LONG	ad_stdesk;
GLOBAL LONG	ad_psp;

GLOBAL BYTE	gl_dta[128];
GLOBAL BYTE	gl_dir[82];
GLOBAL BYTE	gl_1loc[256];
GLOBAL BYTE	gl_2loc[256];
GLOBAL BYTE	pqueue[128];
GLOBAL BYTE	usuper[128];
GLOBAL WORD	gl_mouse[37];

ini_dlongs()
{
	REG LONG	ad_dseg;
	REG BYTE	*ps;
	WORD		i;
	SHELL		*psh;

						/* use all of this 	*/
						/*   initialization	*/
						/*   code area for the	*/
						/*   save area, must be	*/
						/*   on para. boundary	*/
						/*   so new environment	*/
						/*   can be copied here	*/
	ad_ssave = LLCS() + LW(&start);
#if I8086
						/* init. long pointer	*/
						/*   to global array	*/
						/*   which is used by	*/
						/*   resource calls	*/
	ad_dseg = ADDR(&D.g_sysglo[0]) & 0xFFFF0000L;
	ad_sysglo = ad_dseg + LW(&D.g_sysglo[0]);
	ad_windspb = ad_dseg + LW(&wind_spb);
	ad_mouse = ad_dseg + LW(&gl_mouse[0]);
						/* gemfslib longs	*/
	ad_tmp1 = ad_dseg + LW(&gl_tmp1[0]);
	ad_tmp2 = ad_dseg + LW(&gl_tmp2[0]);
						/* gemrslib		*/
	ad_hdrbuff = ad_dseg + LW(&hdr_buff[0]);
						/* gemoblib		*/
	ad_valstr = ad_dseg + LW(&D.g_valstr[0]);
	ad_fmtstr = ad_dseg + LW(&D.g_fmtstr[0]);
	ad_rawstr = ad_dseg + LW(&D.g_rawstr[0]);
	ad_tmpstr = ad_dseg + LW(&D.g_tmpstr[0]);
	ad_edblk = ad_dseg + LW(&edblk);
	ad_bi = ad_dseg + LW(&bi);
	ad_ib = ad_dseg + LW(&ib);
						/* put command in the	*/
						/*   message area of 	*/
						/*   the screen mgr,	*/
						/*   since he gets no	*/
						/*   messsages		*/
	D.s_cmd = (BYTE *) &pqueue[0];
	ad_scmd = ad_dseg + LW(D.s_cmd);
						/* put scrap and some	*/
						/*   other arrays at	*/
						/*   at top of the	*/
						/*   screen mgr stack	*/
	ps = D.g_scrap = (BYTE *) &usuper[0];
	ad_scrap = ad_dseg + LW(ps);
	D.s_cdir = ps += 82;
	ad_scdir = ad_dseg + LW(ps);
	D.g_loc1 = ps = &gl_1loc[0];
	ad_g1loc = ad_dseg + LW(ps);
	D.g_loc2 = ps = &gl_2loc[0];
	ad_g2loc = ad_dseg + LW(ps);
	D.g_dir = ps = &gl_dir[0];
	ad_path = ad_dseg + LW(ps);
	D.g_dta = ps = &gl_dta[0];
	ad_dta = ad_dseg + LW(ps);
	ad_fsdta = ad_dseg + LW(&gl_dta[30]);
#endif
#if MC68K
						/* init. long pointer	*/
						/*   to global array	*/
						/*   which is used by	*/
						/*   resource calls	*/
	ad_sysglo = ADDR(&D.g_sysglo[0]);
	ad_windspb = ADDR(&wind_spb);
	ad_mouse = ADDR(&gl_mouse[0]);
						/* gemfslib longs	*/
	ad_tmp1 = ADDR(&gl_tmp1[0]);
	ad_tmp2 = ADDR(&gl_tmp2[0]);
						/* gemrslib		*/
	ad_hdrbuff = ADDR(&hdr_buff[0]);
						/* gemoblib		*/
	ad_valstr = ADDR(&D.g_valstr[0]);
	ad_fmtstr = ADDR(&D.g_fmtstr[0]);
	ad_rawstr = ADDR(&D.g_rawstr[0]);
	ad_tmpstr = ADDR(&D.g_tmpstr[0]);
	ad_edblk = ADDR(&edblk);
	ad_bi = ADDR(&bi);
	ad_ib = ADDR(&ib);
						/* put command in the	*/
						/*   message area of 	*/
						/*   the screen mgr,	*/
						/*   since he gets no	*/
						/*   messsages		*/
	D.s_cmd = (BYTE *) &pqueue[0];

	ad_scmd = ADDR(D.s_cmd);
						/* put scrap and some	*/
						/*   other arrays at	*/
						/*   at top of the	*/
						/*   screen mgr stack	*/
	ps = D.g_scrap = (BYTE *) &usuper[0];
	ad_scrap = ADDR(ps);
	D.s_cdir = ps += 82;
	ad_scdir = ad_dseg + LW(ps);
	D.g_loc1 = ps = &gl_1loc[0];
	ad_g1loc = ADDR(ps);
	D.g_loc2 = ps = &gl_2loc[0];
	ad_g2loc = ADDR(ps);
	D.g_dir = ps = &gl_dir[0];
	ad_path = ADDR(ps);
	D.g_dta = ps = &gl_dta[0];
	ad_dta = ADDR(ps);
	ad_fsdta = ADDR(&gl_dta[30]);
#endif
}


	VOID
ev_init(evblist, cnt)
	EVB		evblist[];
	WORD		cnt;
{
	WORD		i;

	for(i=0; i<cnt; i++)
	{
	  evblist[i].e_nextp = eul;
	  eul = &evblist[i];
	}
}

/*
*	Create a local process for the routine and start him executing.
*	Also do all the initialization that is required.
*/
	PD
*iprocess(pid, pname, routine)
	WORD		pid;
	BYTE		*pname;
	WORD		(*routine)();
{
	PD		*px;
	REG LONG	ldaddr;

						/* figure out load addr	*/
	ldaddr = LLCS() + ((LONG) routine);
						/*   create process to	*/
						/*   execute it		*/
	return( pstart(routine, pname, ldaddr) );
}



/*
*	Start up the file selector by initializing the fs_tree
*/
	WORD
fs_start()
{
	LONG		tree;

	rs_gaddr(ad_sysglo, R_TREE, 0, &tree);

	ad_fstree = tree;
	ob_center(tree, &gl_rfs);
}


sh_addpath()
{
	LONG		lp, np, new_envr;
	WORD		oelen, oplen, nplen, fstlen;
	BYTE		tmp;

	lp = ad_envrn;
						/* get to end of envrn	*/
	while ( (tmp = LBGET(lp)) ||
		(LBGET(lp+1)) )
	  lp++;
	lp++;
						/* old evironment length*/
	oelen = (lp - ad_envrn) + 2;
						/* new path length	*/
	rs_gaddr(ad_sysglo, R_STRING, ST_INTPATH, &np);
	nplen = LSTRLEN(np);
						/* fix up drive letters	*/
	lp = np;
	while ( tmp = LBGET(lp) )
	{
	  if (tmp == ':')
	    LBSET(lp - 1, dos_gdrv() + 'A');
	  lp++;
	}
						/* alloc new environ	*/
	new_envr = ad_ssave;
	ad_ssave += LW(oelen + nplen);
						/* get ptr to initial	*/
						/*   PATH=		*/
	sh_envrn(ADDR(&lp), ADDR(rs_str(ST_PATH)));
						/* first part length	*/
	oplen = LSTRLEN(lp);
	fstlen = lp - ad_envrn + oplen;
	LBCOPY(new_envr, ad_envrn, fstlen);
	if (oplen)
	{
	  LBSET(new_envr + fstlen, ';');
	  fstlen += 1;
	}
						/* remember new environ.*/
	LBCOPY(new_envr + fstlen, np, nplen);
	LBCOPY(new_envr + fstlen + nplen, lp + oplen, oelen - fstlen);
						/* remember new environ.*/
	ad_envrn = new_envr;
}

sh_init()
{
	WORD		i, cnt, need_ext;
	WORD		drive;
	LONG		lp;
	BYTE		*psrc, *pdst, *pend;
	BYTE		*s_tail;
	SHELL		*psh;

	psh = &sh[0];

	sh_desk(2, ADDR(&ad_pfile));
						/* remember current	*/
						/*   desktop directory	*/
	drive = dos_gdrv();
	D.s_cdir[0] = drive + 'A';
	D.s_cdir[1] = ':';
	D.s_cdir[2] = '\\';
	dos_gdir( drive+1, (ad_scdir + 3) );
						/* add in internal 	*/
						/*   search paths with	*/
						/*   right drive letter	*/
	
	sh_addpath();
						/* set defaults		*/
	psh->sh_doexec = psh->sh_dodef = gl_shgem
		 = psh->sh_isgem = TRUE;
	psh->sh_fullstep = FALSE;
						/* parse command tail	*/
						/*   that was stored in	*/
						/*   geminit		*/
	psrc = s_tail = &D.g_dir[0];		/* reuse part of globals*/
	LBCOPY(ADDR(s_tail), ad_stail, 128);
	cnt = *psrc++;
	if (cnt)
	{
						/* null-terminate it	*/
	  pend = psrc + cnt;
	  *pend = NULL;
						/* scan off leading 	*/
						/*   spaces		*/
	  while( (*psrc) &&
		 (*psrc == ' ') )
	    psrc++;
						/* if only white space	*/
						/*   get out don't	*/
						/*   bother parsing	*/
	  if (*psrc)
	  {
						/* save command to do	*/
						/*   instead of desktop	*/
	    pdst = &D.s_cmd[0];
	    need_ext = TRUE;
	    while ( (*psrc) &&
		    (*psrc != ' ') )
	    {
	      if (*psrc == '.')
	        need_ext = FALSE;
	      *pdst++ = *psrc++;
	    }
						/* append .APP if no	*/
						/*   extension given	*/
	    if (need_ext)
	      strcpy(rs_str(ST_GEM), pdst);
	    else
	      *pdst = NULL;
	    psh->sh_dodef = FALSE;
						/* save the remainder	*/
						/*   into command tail	*/
						/*   for the application*/
	    pdst = &s_tail[1];
	    while ( (*psrc) && 
		    !((*psrc == '/') && (toupper(*(psrc+1)) == 'D')) )
	      *pdst++ = *psrc++;
	    *pdst = NULL;
	    s_tail[0] = strlen(&s_tail[1]);
						/* don't do the desktop	*/
						/*   after this command	*/
						/*   unless a /d was	*/
						/*   encounterd		*/
	    psh->sh_doexec = (*psrc != NULL);
	  }
	}
	LBCOPY(ad_stail, ADDR(s_tail), 128);
}


/*
*	Routine to load program file pointed at by pfilespec, then
*	create new process context for it.  This uses the load overlay
*	function of DOS.  The room for accessories variable will be
*	decremented by the size of the accessory image.  If the
*	accessory is too big to fit it will be not be loaded.
*/
	VOID
sndcli(pfilespec, paccroom)
	REG BYTE	*pfilespec;
	WORD		*paccroom;			/* in paragraphs*/
{
	PD		*px;
	REG WORD	handle;
	WORD		err_ret;
	LONG		ldaddr;


	strcpy(pfilespec, &D.s_cmd[0]);

	handle = dos_open( ad_scmd, ROPEN );
	if (!DOS_ERR)
	{
	  err_ret = pgmld(handle, &D.s_cmd[0], &ldaddr, paccroom);
	  dos_close(handle);
						/* create process to	*/
						/*   execute it		*/
	  if (err_ret != -1)
	    pstart(&gotopgm, pfilespec, ldaddr);
	}
}


/*
*	Routine to load in desk accessory's.  Files by the name of DESK1.ACC
*	DESK2.ACC, and DESK3.ACC will be loaded, if there is sufficient 
*	room for them in the system.  This is determined by subtracting
*	from the total system size, 128kb for the primary app, 4kb for a
*	GSX work station, 8kb for a screen buffer, and 18kb for COMMAND.COM
*	at the top of memory.  The number that this gives is the room 
*	available for desk accessories.
*/
	VOID
ldaccs()
{
	REG WORD	i;
	WORD		ret;
	LONG		laccroom;
	WORD		accroom;

	laccroom = dos_avail() - 0x00027800L;
	accroom = (laccroom + 0x0000000fL) >> 4;

	strcpy(rs_str(ST_DESK1), &D.g_dir[0]);
	dos_sdta(ad_dta);
	ret = TRUE;
	for(i=0; (i<NUM_ACCS) && (accroom > 0) && (ret); i++)
	{
	  ret = (i==0) ? dos_sfirst(ad_path, F_RDONLY) : dos_snext();
	  if (ret)
	    sndcli(&gl_dta[30], &accroom);
	}
}


	VOID
diskcfig()
{
	gl_currdsk = dos_gdrv();
	return( dos_sdrv(gl_currdsk) );		/* return number of disks */
}


/*
*	Return size of each channel in bytes.
*/
	WORD
calcchsz(gl_nmdisk)
{
	UWORD		temp;

	temp = gl_nmdisk * PATH_LEN;
					/* convert to paragraphs	*/
	return( ( (temp + 0x0f) >> 4 ) << 4);
}


main()
{
	WORD		i;
	LONG		tmpadbi;

						/* init longs		*/
	ini_dlongs();
						/* no ticks during init	*/
#if I8086
	cli();
#endif
#if MC68K
	hcli();
#endif	
						/* take the 0efh int.	*/
	takecpm();
						/* init event recorder	*/
	gl_recd = FALSE;
	gl_rlen = 0;
	gl_rbuf = 0x0L;
						/* initialize pointers	*/
						/*   to heads of event	*/
						/*   list and thread	*/
						/*   list		*/
	elinkoff = (BYTE *) &evx.e_link - (BYTE *) &evx;
						/* link up all the evb's*/
						/*   to the event unused*/
						/*   list		*/
	eul = 0;
	ev_init(&D.g_intevb[0], NUM_IEVBS);
	if (totpds > 2)
	  ev_init(&D.g_extevb[0], NUM_EEVBS);

						/* initialize list	*/
						/*   and unused lists	*/
	nrl = drl = 0;
	dlr = zlr = 0;
	fph = fpt = fpcnt = 0;
	infork = 0;
						/* initialize sync	*/
						/*   blocks		*/
	wind_spb.sy_tas = 0;
	wind_spb.sy_owner = 0;
	wind_spb.sy_wait = 0;
						/* init initial process	*/
	totpds = NUM_PDS;
	for(i=totpds-1; i>=0; i--)
	{
	  rlr = pd_index(i);
	  if (i < 2) 
	  {
	    rlr->p_uda = &D.g_intuda[i];
	    rlr->p_cda = &D.g_intcda[i];
	  }
	  else
	  {
	    rlr->p_uda = &D.g_extuda[i-2];
	    rlr->p_cda = &D.g_extcda[i-2];
	  }
	  rlr->p_qaddr = ADDR(&rlr->p_queue[0]);
	  rlr->p_qindex = 0;
	  bfill(8, ' ', &rlr->p_name[0]);
						/* if not rlr then	*/
						/*   initialize his	*/
						/*   stack pointer	*/
	  if (i != 0)
	    rlr->p_uda->u_spsuper = &rlr->p_uda->u_supstk;
						/* set pid, stat for	*/
						/*   saveproc		*/
	  rlr->p_pid = i;
	  rlr->p_stat = 0;
	  saveproc();
	}
	curpid = 0;
	rlr->p_pid = curpid++;
	rlr->p_link = 0;
	cda = rlr->p_cda;
						/* restart the tick	*/
#if I8086
	sti();
#endif
#if MC68K
	hsti();
#endif	
						/* screen manager 	*/
						/*   process init. this	*/
						/*   process starts out	*/
						/*   owning the mouse	*/
						/*   and the keyboard.	*/
						/*   it has a pid == 1	*/
	gl_dacnt = 0;
	gl_mowner = ctl_pd = iprocess(rlr->p_pid, "SCRENMGR.LOC", &ctlmgr);
	if (totpds > 2)
	{
	  for (i=0; i<NUM_NULP; i++)
	    iprocess(i + ctl_pd->p_pid, "AVAILNUL.LOC", &nulmgr);
	}

						/* get gl_nmdisk	*/
	gl_nmdisk = diskcfig();
						/* get gl_chnlsz	*/
	gl_chnlsz = calcchsz(gl_nmdisk);
						/* load gem resource	*/
						/*   and fix it up 	*/
						/*   before we go	*/
	if ( !rs_readit(ad_sysglo, ADDR("GEM.RSC")) ) 
	{
	  /* bad resource load, so dive out */
	}
	else
	{
						/* get mice forms	*/
	  rs_gaddr(ad_sysglo, R_BIPDATA, 3 + ARROW, &ad_armice);
	  ad_armice = LLGET(ad_armice);
	  rs_gaddr(ad_sysglo, R_BIPDATA, 3 + HGLASS, &ad_hgmice);
	  ad_hgmice = LLGET(ad_hgmice);
						/* load all desk acc's	*/
/*
	  if (totpds > 2)
	    ldaccs();
*/
						/* init button stuff	*/
	  gl_btrue = 0x0;
	  gl_bdesired = 0x0;
	  gl_bdely = 0x0;
	  gl_bclick = 0x0;
						/* do gsx open work	*/
						/*   station	 	*/
	  gsx_init();
						/* fix up icons		*/
	  for(i=0; i<3; i++)
	  {
	    rs_gaddr(ad_sysglo, R_BITBLK, i, &tmpadbi);
	    LBCOPY(ad_bi, tmpadbi, sizeof(BITBLK));
	    gsx_trans(bi.bi_pdata, bi.bi_wb, bi.bi_pdata, bi.bi_wb, bi.bi_hl);
	  }
						/* take the critical err*/
						/*   handler int.	*/
	  cli();
	  takeerr();
	  sti();
						/* go into graphic mode	*/
	  sh_tographic();
						/* take the tick int.	*/
	  cli();
	  gl_ticktime = gsx_tick(tikaddr, &tiksav);
	  sti();
						/* set init. click rate	*/
	  ev_dclick(3, TRUE);
						/* fix up the GEM rsc.	*/
						/*   file now that we	*/
						/*   have an open WS	*/ 
	  rs_fixit(ad_sysglo);
						/* init. window vars.	*/
	  wm_start();
						/* startup gem libs	*/
	  fs_start();
						/* get st_desk ptr	*/
	  rs_gaddr(ad_sysglo, R_TREE, 2, &ad_stdesk);
						/* off we go !!!	*/
	  dsptch();
						/* let them run		*/
	  all_run();
						/* init for shell loop	*/
						/*   up thru here it is	*/
						/*   okay for system	*/
						/*   to overlay this 	*/
						/*   initialization code*/
	  sh_init();
						/* fix up chnl_zero to	*/
						/*   be only channel	*/
	  chnl_zero();

	  rlr->p_stat |= SWITCHIN;
	  loadproc();
						/* main shell loop	*/
						/*   from here on down	*/
						/*   data should not	*/
						/*   overlay this code	*/
	  sh_main();

	  saveproc();
	  rlr->p_stat &= ~SWITCHIN;
						/* fixup memory		*/
	  pr_exit();
						/* free up resource	*/
						/*   space		*/
	  rs_free(ad_sysglo);
						/* give back the tick	*/
	  cli();
 	  gl_ticktime = gsx_tick(tiksav, &tiksav);
	  sti();
						/* close workstation	*/
	  gsx_wsclose();
	}
						/* return GEM's 0xEF int*/
	cli();
	givecpm();
	sti();
}

/*
*	Give everyone a chance to run, at least once
*/

all_run()
{
	WORD		i;

						/* let all the acc's run*/
	  for(i=0; i<NUM_ACCS; i++)
	    dsptch();
						/* then get in the wait	*/
						/*   line		*/
	  wm_update(TRUE);
	  wm_update(FALSE);
}


	VOID
sh_desk(obj, plong)
	WORD		obj;
	LONG		plong;
{
	REG LONG	tree;

	tree = ad_stdesk;
	LLSET(plong, LLGET(OB_SPEC(obj)));
}
