/*	GEMSHLIB.C	4/18/84 - 07/10/85	Lee Lorenzen		*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>
#include <struct88.h>
#include <baspag88.h>
#include <dos.h>
#include <gemdefn.h>
#include <gemlib.h>


EXTERN VOID	cpmcod();

EXTERN WORD	strlen();
EXTERN PD	*fpdnm();
						/* in FMLIB.C		*/
EXTERN WORD	fm_error();
						/* in AINTS88.C		*/
EXTERN WORD	terminate();
						/* in DOS.C		*/
EXTERN VOID	dos_exec();
EXTERN WORD	dos_wait();

EXTERN WORD	DOS_AX;
EXTERN WORD	DOS_ERR;
EXTERN WORD	cli();				/* in DOSIF.A86		*/
EXTERN WORD	sti();
EXTERN WORD	takeerr();
EXTERN WORD	giveerr();
EXTERN WORD	retake();
						/* in GSXIF.C		*/
EXTERN WORD	gsx_init();
EXTERN WORD	gsx_graphic();
EXTERN WORD	gsx_wsclose();
EXTERN WORD	gsx_malloc();
EXTERN WORD	gsx_mfree();
						/* in RSLIB.C		*/
EXTERN BYTE	*rs_str();
						/* in GSXIF.C		*/
EXTERN WORD	gl_handle;
EXTERN WORD	gl_width;
EXTERN WORD	gl_height;
EXTERN WORD	gl_wchar;
EXTERN WORD	gl_hchar;
EXTERN WORD	gl_wbox;
EXTERN WORD	gl_hbox;
EXTERN GRECT	gl_rscreen;
EXTERN GRECT	gl_rfull;
EXTERN GRECT	gl_rmenu;

EXTERN LONG	tikaddr;
EXTERN LONG	tiksav;
EXTERN WORD	gl_ticktime;

EXTERN LONG	ad_sysglo;
EXTERN LONG	ad_envrn;
EXTERN LONG	ad_stdesk;
EXTERN LONG	ad_armice;
EXTERN LONG	ad_hgmice;

EXTERN LONG	gl_mntree;

EXTERN PD	*ctl_pd;

EXTERN LONG	desk_tree[];

EXTERN THEGLO	D;

GLOBAL WORD	nulp_msg[8];

GLOBAL SHELL	sh[NUM_PDS];

GLOBAL LONG	ad_scmd;
GLOBAL LONG	ad_s1fcb;
GLOBAL LONG	ad_s2fcb;
GLOBAL LONG	ad_stail;
GLOBAL LONG	ad_ssave;
GLOBAL LONG	ad_dta;
GLOBAL LONG	ad_path;

GLOBAL LONG	ad_pfile;

GLOBAL LONG	ad_scdir;

GLOBAL WORD	gl_shgem;

GLOBAL LONG	gl_efnorm, gl_efsave;

	WORD
sh_read(pcmd, ptail)
	LONG		pcmd, ptail;
{
	LBCOPY(pcmd, ad_scmd, 128);
	LBCOPY(ptail, ad_stail, 128);
}


/*
*	Routine to set the next application to run
*
*		isgem = 0   then run in character mode
*		isgem = 1   them run in graphic mode
*
*		isover = 0  then run above DESKTOP
*		isover = 1  then run over DESKTOP
*		isover = 2  then run over AES and DESKTOP
*/
	WORD
sh_write(doex, isgem, isover, pcmd, ptail)
	WORD		doex, isgem, isover;
	LONG		pcmd, ptail;
{
	SHELL		*psh;

	LBCOPY(ad_scmd, pcmd, 128);
	LBCOPY(ad_stail, ptail, 128);
	if (isover > 0)
	{
						/* stepaside to run	*/
	  psh = &sh[rlr->p_pid];
	  psh->sh_isgem = (isgem != FALSE);
	  psh->sh_doexec = doex;
	  psh->sh_dodef = FALSE;
	  psh->sh_fullstep = isover - 1;
	}
	else
	{
						/* run it above us	*/
	  sh_fixtail();
	  if ( sh_find(ad_scmd, NULL) )
	  {
	    dos_exec(ad_scmd, LHIWD(ad_envrn), 
			ad_stail, ad_s1fcb, ad_s2fcb);
	  }
	  else
	    return(FALSE);
	}
	return(TRUE);				/* for the future	*/
}


/*
*	Used by the DESKTOP to recall 1024 bytes worth of previously
*	'put' desktop-context information.
*/
	WORD
sh_get(pbuffer, len)
	LONG		pbuffer;
	WORD		len;
{
	LBCOPY(pbuffer, ad_ssave, len);
}


/*
*	Used by the DESKTOP to save away 1024 bytes worth of desktop-
*	context information.
*/
	WORD
sh_put(pdata, len)
	LONG		pdata;
	WORD		len;
{
	LBCOPY(ad_ssave, pdata, len);
}


/*
*	Convert the screen to graphics-mode in preparation for the 
*	running of a GEM-based graphic application.
*/
	WORD
sh_tographic()
{
						/* retake ints that may	*/
						/*   have been stepped	*/
						/*   on by char. appl.	*/
						/*   including err. 	*/
						/*   handler and gem.int*/
	cli();
	retake();
	sti();
						/* convert to graphic	*/
	gsx_graphic(TRUE);
						/* set initial clip rect*/
	gsx_sclip(&gl_rscreen);
						/* allocate screen space*/
	gsx_malloc();
						/* start up the mouse	*/
	ratinit();
						/* put mouse to hourglass*/
	gsx_mfset(ad_hgmice);
}


/*
*	Convert the screen and system back to alpha-mode in preparation for
*	the running of a DOS-based character application.
*/
	WORD
sh_toalpha()
{
						/* put mouse to arrow	*/
	gsx_mfset(ad_armice);
						/* give back the error	*/
						/*   handler since ours	*/
						/*   is graphic		*/
	cli();
	giveerr();
	sti();
						/* turn off the mouse	*/
	ratexit();
						/* return screen space	*/
	gsx_mfree();
						/* close workstation	*/
	gsx_graphic(FALSE);
}



/*
*	Routine called everytime dos_find has another path to search
*/
	VOID
sh_draw(lcmd, start, depth)
	LONG		lcmd;
	WORD		start;
	WORD		depth;
{
	LONG		tree;
	SHELL		*psh;

	psh = &sh[rlr->p_pid];

	if (gl_shgem)
	{
	  tree = ad_stdesk;
	  gsx_sclip(&gl_rscreen);
	  LLSET(ad_pfile, lcmd);
	  ob_draw(tree, start, depth);
	}
}


/*
*	Routine called everytime dos_find has another path to search
*/

sh_show(lcmd)
	LONG		lcmd;
{
	WORD		i;

	for(i=1; i<3; i++)
	  sh_draw(lcmd, i, 0);
}


/*
*	Routine to take a full path, and scan back from the end to 
*	find the starting byte of the particular filename
*/
	BYTE
*sh_name(ppath)
	REG BYTE	*ppath;
{
	REG BYTE	*pname;

	pname = &ppath[strlen(ppath)];
	while ( (pname >= ppath) &&
		(*pname != '\\') &&
		(*pname != ':') )
	  pname--;
	pname++;
	return(pname);
}


/*
*	Search for a particular string in the DOS environment and return
*	a long pointer to the character after the string if it is found. 
*	Otherwise, return a NULLPTR
*/
	VOID
sh_envrn(ppath, psrch)
	LONG		ppath;
	REG LONG	psrch;
{
	LONG		lp, ad_loc1;
	WORD		len, findend;
	BYTE		tmp, loc1[10], loc2[10];

	len = LSTCPY(ADDR(&loc2[0]), psrch);
	len--;
	ad_loc1 = ADDR(&loc1[0]);
	loc1[len] = NULL;

	lp = ad_envrn;
	findend = FALSE;
	do
	{
	  tmp = LBGET(lp);
	  lp++;
	  if ( (findend) &&
	       (tmp == NULL) )
	  {
	    findend = FALSE;
	    tmp = 0xFF;
	  }
	  else
	  {
	    if (tmp == loc2[0])
	    {
	      LBCOPY(ADDR(&loc1[0]), lp, len);
	      if ( strcmp(&loc1[0], &loc2[1]) )
	      {
	        lp += len;
	        break;
	      }
	    }
	    else
	      findend = TRUE;
	  }
	} while( tmp );
	if (!tmp)
	  lp = 0x0L;
	LLSET(ppath, lp);
}


/*
*	Search first, search next style routine to pick up each path
*	in the PATH= portion of the DOS environment.  It returns the
*	next higher number to look for until there are no more
*	paths to find.
*/

	WORD
sh_path(whichone, dp, pname)
	WORD		whichone;
	LONG		dp;
	REG BYTE	*pname;
{
	REG BYTE	tmp, last;
	LONG		lp;
	REG WORD	i;
						/* find PATH= in the	*/
						/*   command tail which	*/
						/*   is a double null-	*/
						/*   terminated string	*/
	sh_envrn(ADDR(&lp), ADDR(rs_str(ST_PATH)));
	if (!lp)
	  return(0);
	i = whichone;
						/* if found count in to	*/
						/*   appropriate path	*/
	while (i)
	{
	  while ( (tmp = LBGET(lp)) ||
		  (LBGET(lp+1)) )
	  {
	    lp++;
	    if (tmp == ';')
	      break;
	  }
	  i--;
	}
	if (!tmp)
	  return(0);
						/* copy over path	*/
	while ( tmp = LBGET(lp) )
	{
	  if ( tmp != ';' )
	  {
	    LBSET(dp++, tmp);
	    last = tmp;
	    lp++;
	  }
	  else
	    break;
	}
						/* see if extra slash	*/
						/*   is needed		*/
	if ( (last != '\\') &&
	     (last != ':') )
	  LBSET(dp++, '\\');
						/* append file name	*/
	LSTCPY(dp, ADDR(pname));
						/* make whichone refer	*/
						/*   to next path	*/
	return(whichone+1);
}


/*
*	Routine to verify that a file is present.  It first looks in the
*	current directory and then looks down the search path.  Before
*	it looks at each point it firsts call the passed-in routine with
*	the filespec that is looking for.
*/
	WORD
sh_find(pspec, routine)
	LONG		pspec;
	WORD		(*routine)();
{
	WORD		len, path;
	BYTE		*pname, tmpname[14];

	dos_sdta(ad_dta);

	len = LSTCPY(ad_path, pspec);
	pname = sh_name(&D.g_dir[0]);
	strcpy(pname, &tmpname[0]);			

	path = 0;
	do
	{

	  dos_sfirst(ad_path, F_RDONLY | F_SYSTEM);

	  if ( (DOS_ERR) && 
	       ((DOS_AX == E_FILENOTFND) || 
		(DOS_AX == E_NOFILES) ||
		(DOS_AX == E_PATHNOTFND)) )
	  {
	    path = sh_path(path, ad_path, &tmpname[0]);
	    DOS_ERR = TRUE;
	  }
	  else
	    path = FALSE;
	} while ( DOS_ERR && path );

	if (!DOS_ERR)
	{
	  LSTCPY(pspec, ad_path);
	  if (routine)
	    (*routine)(ad_path);
	}
	return(!DOS_ERR);
}



 	BYTE
*sh_parse(psrc, pfcb)
	REG BYTE	*psrc;
	REG BYTE	*pfcb;
{
	REG BYTE	*ptmp;
	BYTE		*sfcb;
	BYTE		drv;

	sfcb = pfcb;
						/* scan off white space	*/
	while ( (*psrc) &&
	        (*psrc == ' ') )
	  *psrc++;
	if (*psrc == NULL)
	  return(psrc);
						/* remember the start	*/
	ptmp = psrc;
						/* look for a colon	*/
	while ( (*psrc) &&
		(*psrc != ' ') &&
		(*psrc != ':') )
	  *psrc++;
						/* pick off drive letter*/
	drv = 0;
	if ( *psrc == ':' )
	{
	  drv = toupper(*(psrc - 1)) - 'A' + 1;
	  psrc++;
	}
	else
	  psrc = ptmp;
	*pfcb++ = drv;
	if (*psrc == NULL)
	  return(psrc);
						/* scan off filename	*/
	while ( (*psrc) &&
		(*psrc != ' ') &&
		(*psrc != '*') &&
		(*psrc != '.') &&
		(pfcb <= &sfcb[8]) )
	  *pfcb++ = toupper(*psrc++);
						/* pad out with blanks	*/
	while ( pfcb <= &sfcb[8] )
	  *pfcb++ = (*psrc == '*') ? ('?') : (' ');
	if (*psrc == '*')
	  psrc++;
						/* scan off file ext.	*/
	if ( *psrc == '.')
	{
	  psrc++;
	  while ( (*psrc) &&
		  (*psrc != ' ') &&
		  (*psrc != '*') &&
		  (pfcb <= &sfcb[11]) )
	    *pfcb++ = toupper(*psrc++);
	}
	while ( pfcb <= &sfcb[11] )
	  *pfcb++ = (*psrc == '*') ? ('?') : (' ');
	if (*psrc == '*')
	  psrc++;
						/* return pointer to	*/
						/*   remainder of line	*/
	return(psrc);
}


/*
*	Routine to fix up the command tail and parse FCBs for a coming
*	exec.
*/
	VOID
sh_fixtail()
{
	REG WORD	i;
	BYTE		*s_tail;
	BYTE		*ptmp;
	BYTE		s_fcbs[32];
	SHELL		*psh;

	psh = &sh[rlr->p_pid];
						/* zero the fcbs	*/
	bfill(32, 0, &s_fcbs[0]);
	bfill(11, ' ',  &s_fcbs[1]);
	bfill(11, ' ',  &s_fcbs[17]);
						/* upcase the tail	*/
	s_tail = &D.g_dir[0];			/* reuse part of globals*/
	LBCOPY(ADDR(s_tail), ad_stail, 128);
						/* parse the fcbs	*/
	if ( s_tail[0] )
	{
	  s_tail[ 1 + s_tail[0] ] = NULL;
	  ptmp = sh_parse(&s_tail[1], &s_fcbs[0]);
	  if (*ptmp != NULL)
	    sh_parse(ptmp, s_fcbs[16]);
	  s_tail[ 1 + s_tail[0] ] = 0x0d;
	}
						/* copy into true fcbs	*/
	LBCOPY(ad_s1fcb, ADDR(&s_fcbs[0]), 16); 
	LBCOPY(ad_s2fcb, ADDR(&s_fcbs[16]), 16); 
	LBCOPY(ad_stail, ADDR(s_tail), 128);
}


sh_chkgrf()
{
	SHELL		*psh;

	psh = &sh[rlr->p_pid];
	if ( psh->sh_isgem != gl_shgem )
	{
	  gl_shgem = psh->sh_isgem;
	  if ( gl_shgem )
	    sh_tographic();
	  else
	    sh_toalpha();
	}
}


	VOID
ldapp()
{
	WORD		wh, ret, badtry, retry;
	SHELL		*psh;

	psh = &sh[rlr->p_pid];

	do
	{
	  wh = 0;
	  if (gl_shgem != psh->sh_isgem)
	  {
	    wh = wm_create(0x0, &gl_rscreen);
	    wm_open(wh, &gl_rscreen);
	    gl_mntree = 0x0L;
	  }
	  sh_chkgrf();
						/* init switch state	*/
	  rlr->p_stat |= SWITCHIN;
	  loadproc();
						/* clear his desk field	*/
	  desk_tree[rlr->p_pid] = 0x0L;
						/* KLUDGE to save int EF*/
	  gl_efsave = LLGET(0xefL * 4);
	  gl_efnorm =  LLCS() | LW(&cpmcod);
	  LLSET(0xefL * 4, gl_efnorm);

	  psh->sh_dodef = TRUE;
	  	  	  	  	  /* exec it	  	  */
					  /* handle bad try msg	*/
	  badtry = 0;	
	  do
	  {
	    retry = FALSE;
	    if ( sh_find(ad_scmd, sh_show) )
	    {
	      p_nameit(rlr, sh_name(&D.s_cmd[0]));
	      dos_exec(ad_scmd, LHIWD(ad_envrn), ad_stail, 
			ad_s1fcb, ad_s2fcb);
	      if (DOS_ERR)
		badtry = (psh->sh_isdef) ? ALRTNOFIT : ALRT08ERR;
	    }
	    else
	    {
	      if ( (gl_shgem) &&
		   (psh->sh_isdef) )
	      {
		ret = fm_show(ALRTOKDESK, NULLPTR, 1);
		if (ret == 1)
		  retry = TRUE;
		else
		  retry = psh->sh_doexec = FALSE;
	      }
	      else
		badtry = ALRT18ERR;
	    }
	  } while (retry && !badtry);

	  if(gl_efsave)
	    LLSET(0xefL * 4, gl_efnorm);

	  if (DOS_ERR)
	  {
	    /* hndl error case */
	  }

	  saveproc();
	  rlr->p_stat &= ~SWITCHIN;
						/* clear his desk field	*/
	  desk_tree[rlr->p_pid] = 0x0L;

	  psh->sh_isgem = TRUE;
	  sh_chkgrf();
	  if (wh)
	  {
	    gsx_mfset(ad_armice);
	    wm_close(wh);
	    wm_delete(wh);
	  }

	  if (badtry)
	  {
	    ret = fm_show(badtry, NULLPTR, 1);
	    if (badtry == ALRTNOFIT)
	      break;
	    badtry = 0;
	  }
	  	  	  	  	  /* name avail again	  */
	  p_nameit(rlr, "AVAILNUL");
	} while(!psh->sh_dodef && psh->sh_doexec);
}


/*
*
*/
	VOID
sh_chkdef(psh)
	SHELL		*psh;
{
						/* if we should exec	*/
						/*   the default command*/
						/*   then let it be	*/
						/*   known that it is	*/
						/*   a gem appl.	*/
	psh->sh_isdef = FALSE;
	if ( psh->sh_dodef )
	{
	  psh->sh_isdef = psh->sh_isgem = TRUE;
	  dos_sdrv(D.s_cdir[0] - 'A');
	  dos_chdir(ad_scdir);
	  strcpy(rs_str(ST_DESKTOP), &D.s_cmd[0]);
	}
}


sh_main()
{
	WORD		i, ret, firstime;
	SHELL		*psh;

	psh = &sh[rlr->p_pid];

	wm_start();
	ratinit();
	firstime = TRUE;
	do
	{
	  sh_chkdef(psh);
	  if(firstime)
	  {
	    sh_draw(ad_scmd, 0, MAX_DEPTH);
	    firstime = FALSE;
	  }
						/* set up so that we	*/
						/*   will exec the 	*/
						/*   default next time	*/
						/*   unless the		*/
						/*   application does	*/
						/*   a set command	*/
	  psh->sh_dodef = TRUE;
						/* fix up/parse cmd tail*/ 
	  sh_fixtail();
						/* do the exec		*/
	  ldapp();

	} while ( psh->sh_doexec );
						/* get back to alpha	*/
						/*   mode if necessary	*/
	if (gl_shgem)
	  sh_toalpha();
}

