#include <stdio.h>

#define	MC68000	1	/* 68000 version */
#define	CPM	1	/* CP/M Operating System*/

/*
 *	Defining the names in this manner allows using the V7 UNIX library
 *	to run the asinine V6 calls in the Alcyon software.
 *
*/
#define	fopen	fopenb
#define	strcmp	_strcmp

#define HDSIZE  (sizeof couthd) /**.o file header size*/
struct hdr {
        short ch_magic;         /*c.out magic number 060016 = $600E*/
        long ch_tsize;          /*text size*/
        long ch_dsize;          /*data size*/
        long ch_bsize;          /*bss size*/
        long ch_ssize;          /*symbol table size*/
        long ch_stksize;        /*stack size*/
        long ch_entry;          /*entry point*/
        short ch_rlbflg;        /*relocation bits suppressed flag*/
} couthd={0};

#define MAGIC   0x601a  /* bra .+26 instruction*/
/* format of a symbol entry in the main table*/

#define SEEKREL	1	/*relative seek flag*/

#define  OSTSIZE	14		/*symbol table entry length on object file*/
							/* without table link*/
# define STESIZE	18		/*byte length of symbol table entry*/
struct symtab {
	char name[8];		/*symbol name*/
	short  flags;			/*bit flags*/
	long  vl1;			/*symbol value*/
	char  *tlnk;			/*table link*/
};

struct symtab *symptr;

/* flags for symbols*/
# define SYDF	0100000		/*defined*/
# define SYEQ	0040000		/*equated*/
# define SYGL	0020000		/*global - entry or external*/
# define SYER	0010000		/*equated register*/
# define SYXR	0004000		/*external reference*/
# define SYDA	0002000		/*DATA based relocatable*/
# define SYTX	0001000		/*TEXT based relocatable*/
# define SYBS	0000400		/*BSS based relocatable*/

struct irts {
	char *irle;		/*ptr to last entry in chain*/
	char *irfe;		/*ptr to first entry in chain*/
};

#ifdef	VAX
struct {
	short loword;
	short hiword;
};
#endif
#ifdef	PDP11
struct {
	short loword;
	short hiword;
};
#endif

#ifdef	MC68000
struct {
	short hiword;
	short loword;
};
#endif
#ifdef	VAX
struct {
	char lobyte;
	char hibyte;
};
#endif
#ifdef	PDP11
struct {
	char lobyte;
	char hibyte;
};
#endif
#ifdef	MC68000
struct {
	char hibyte;
	char lobyte;
};
#endif
/* relocation bit definitions:*/
#define RBMASK		07		/*tells type of relocation*/
#define INSABS		7		/*first word of instr -- absolute*/
#define DABS		0		/*data word absolute*/
#define TRELOC		2		/* TEXT relocatable*/
#define DRELOC		1		/* DATA relocatable*/
#define BRELOC		3		/* BSS relocatable*/
#define EXTVAR		4		/* ref to external variable*/
#define LUPPER		5		/* upper word of long*/

struct buf{
	int fildes;
	int nunused;
	char *xfree;
	char buff[512];
};
	       
FILE *ibuf, *fopen();
char *ifilname=0;


#define MAGIC1 (MAGIC+1)
#define FORMFEED ('\014')

#define PUBFUNC	(1)
#define PUBDATA	(2)
#define PUBBSS	(4)
#define EXTREF	(8)
#define	COMREF	(16)
#define GLOBREF (PUBFUNC | PUBDATA | PUBBSS)

	/* Cross Reference Table Type */

typedef struct tnode {
	char *tname;
	char *module;
	int symtype;
	struct tnode *tnext;	/* link for = symbols */
	struct tnode *tleft;	/* link for < symbols */
	struct tnode *tright;	/* link for > symbols */
} treenode;

char *cur_module = NULL;
treenode *symtree = NULL;

int hdsize=0;

int loctr=0;
int pflg=0;
int syno=0;
int symflg;
long fseek();

char cur_hdr[81];

main(argc,argv)

char **argv;

{
	long fpos, l, l1, rwind();
        register i, j, k;
	char *cpos, *index();
	int print_table();

        if(argc<2) {
                printf("Usage: xref objectfile\n");
                exit();
        }
        hdsize = HDSIZE;
	while (--argc) {
	    if ( openfile( cur_module = *++argv ) != 0 )
	    {
	    	fprintf( stderr, "Error reading %s\n", cur_module );
		continue;
	    }
	    if ((cpos = index( cur_module, '.' )) != NULL)
	    	*cpos = '\0';
	    if ((cpos = index( cur_module, ':')) != NULL)
		strcpy( cur_module, cpos + 1 );
	    fpos = couthd.ch_tsize+couthd.ch_dsize+hdsize;
	    load_table( rwind( fpos ), GLOBREF | EXTREF );
	    fclose( ibuf );
	}
	printf("%56s\n\n", "CP/M 68k Cross Reference Listing");
	strcpy( cur_hdr, "Functions:\n" );
	prt_hdr();
	if (print_table( symtree, PUBFUNC ) == 0)
	    printf("    None\n");
	strcpy( cur_hdr, "\n\014Data:\n");
	prt_hdr();
	if (print_table( symtree, PUBDATA ) == 0)
	    printf("    None\n");
	strcpy( cur_hdr, "\n\014Block Data:\n");
	prt_hdr();
	if (print_table( symtree, PUBBSS ) == 0)
	    printf("    None\n");
	strcpy( cur_hdr, "\n\014Undefined External References:\n");
	prt_hdr();
	if (print_table( symtree, EXTREF ) == 0)
	    printf("    None\n");
	putchar('\014');
}

prt_hdr()

{
	register int i;
	
	printf("%s", cur_hdr);
	printf(" Symbol      Defined In  Accessed In\n");
	for (i = 0; i<70; i++)
	    putchar('-');
	putchar('\n');
}

static load_table( l1, flagtype )

long l1;
int flagtype;

{
	int i, j, k, numprt, loadit, thisflag;
	long l;
	char symname[10];
	treenode *addtree(), *symentry;
	
	numprt = 0;
        while(l1) {
                for(i=0; i<8; i++)                      /* Print Symbol name*/
                {
                        k = getc(ibuf) & 0377;
                        if (k < ' ') k = ' ';           /* Filter ctrl chars*/
			symname[i] = k;
                }
		symname[i] = '\0';
                j = getw(ibuf);                /*flags*/
                l.hiword = getw(ibuf);
                l.loword = getw(ibuf);
		thisflag = loadit = 0;
			/* Fix for common data.  If size > 0,
			   then declared in this module */
		if ((j & SYXR) && (l > 0l))
		{
		    j &= ~SYXR;
		    j |= SYBS;
		    thisflag |= COMREF;
		}
		if (flagtype & EXTREF)
		{
		    if (loadit |= (j & SYXR))
			thisflag |= EXTREF;
		}
		if ((flagtype & GLOBREF) && !loadit)
		{
		    loadit |= (j & SYGL);
		    if (j&SYGL && j&SYTX && !(j&SYXR))
			thisflag |= PUBFUNC;
		    else if (j&SYGL && j&SYDA && !(j&SYXR))
			thisflag |= PUBDATA;
		    else if (j&SYGL && j&SYBS)
			thisflag |= PUBBSS;
		}
		if (loadit)
		{
		    symentry = addtree( &symtree, symname,
		    				thisflag, cur_module );
		}
                l1 -= OSTSIZE;
        }
}

static long rwind( fpos )

long fpos;

{
        fseek(ibuf,fpos,0);
        return( couthd.ch_ssize );
}

/***************************************************************************
prtflags(af)
{

        register f;

        f = af;
        if(f&SYEQ)
                printf(" equ");
        if(f&SYGL)
                printf(" global");
        if(f&SYER)
                printf(" reg");
        if(f&SYXR)
                printf(" external");
        if(f&SYDA)
                printf(" data");
        else if(f&SYTX)
                printf(" text");
        else if(f&SYBS)
                printf(" bss");
        else
                printf(" abs");
        putchar((char)'\n');
}
***************************************************************************/

int openfile(ap)
char *ap;
{

        register char *p;

        p = ap;
        if((ibuf=fopen(p,"r")) < 0) {
                printf("unable to open %s\n",p);
                return( -1 );
        }
        ifilname = p;   /*point to current file name for error msgs*/
        if(fread(&couthd,1,2,ibuf) != 2) {
                printf("read error on file: %s\n",ifilname);
                return( -1 );
        }
        fseek(ibuf,0L,0);
        return( readhdr() );		/*read file header*/
}
int readhdr()
{

        register int i;
        register short *p;

        p = &couthd;
        for(i=0; i<HDSIZE/2; i++)
                *p++ = getw(ibuf);
        if(couthd.ch_magic != MAGIC) {
                if(couthd.ch_magic==MAGIC1) {
                        hdsize += 8;
                }
                else {
                        printf("file format error: %s\n",ifilname);
                        return( -1 );
                }
        }
	return( 0 );
}

treenode *addtree( tree, symb, flagtype, mod_name )

treenode **tree;
char *symb, *mod_name;
int flagtype;

{
	treenode *pos, *eqpos, *addpos, *treealloc();
	char searchem, *temp;
	int comptst, strcmp();
	
	if (*tree == NULL)
		return( *tree = treealloc( symb, flagtype, mod_name ) );
	pos = *tree;
	while (1) {
		comptst = strcmp( symb, pos->tname );
		if ( comptst < 0 )
			/** If no more left branches, make a new entry **/
		{
		    if (pos->tleft == NULL)
			return( pos->tleft = treealloc( symb, flagtype,
							mod_name ) );
		    pos = pos->tleft;
		    continue;
		}
		else if (comptst > 0)
			/** If no more right branches, make a new entry **/
		{
		    if (pos->tright == NULL)
			return( pos->tright = treealloc( symb, flagtype,
							 mod_name ) );
		    pos = pos->tright;
		    continue;
		}
			/** If symbol already exists in the table,
			    check for multiple equal symbols that
			    have global references.  If they do,
			    print an error msg.  Then add it to the
			    table in another tree.  If they don't have
			    other global references, put it in the equal
			    list with the global reference type **/

		if ((pos->symtype & GLOBREF) && (flagtype & GLOBREF) &&
		    !(pos->symtype & COMREF) && !(flagtype & COMREF))
			/** Two symbols with global references **/
		{
		    fprintf( stderr, "Duplicate symbol: %s\n", symb );
		    if (pos->tright == NULL)
			return( pos->tright = treealloc( symb, flagtype,
							 mod_name ) );
			/** allocate a new symbol in the right tree **/
		    pos = pos->tright;
		    while (pos->tleft != NULL)
			pos = pos->tleft;
		    return( pos->tleft = treealloc( symb, flagtype,
		    				    mod_name ) );
		}
		else
		    if ((flagtype & GLOBREF) &&
		        (!(pos->symtype & GLOBREF) || (pos->symtype & COMREF)))

			/** Previous value was not a global reference, but
			    the new value is a global reference, so must
			    insert it at the head of the list and then set all
			    of the sub trees to the same global reference.
			    **/
		{
		    eqpos = pos;
		    while (1) {
			eqpos->symtype = flagtype;
			if (eqpos->tnext == NULL)
			    break;
			eqpos = eqpos->tnext;
		    }
		    eqpos->tnext = treealloc( symb, flagtype, mod_name );
		    eqpos = eqpos->tnext;
			/** Now must switch so that the first module
			    in the tree has the global reference **/
		    temp = eqpos->module;
		    eqpos->module = pos->module;
		    pos->module = temp;
		    return( eqpos );
		}
			/** The symbols are the same but there are no
			    global conflicts.  Insert the symbol in the
			    equal list with the first symbol type if it
			    is a global **/
		eqpos = pos;
		while (pos->tnext != NULL)
		    pos = pos->tnext;
		return( pos->tnext = treealloc( symb, eqpos->symtype,
						mod_name ) );
	}
}

treenode *treealloc( symb, flagtype, mod_name )

char *symb, *mod_name;
int flagtype;

{
	register treenode *tree;
	char *malloc();
	
	if ( (tree = (treenode *)malloc( sizeof( treenode ) )) == 0)
	{
		fprintf(stderr, "Not enough memory for symbol: %s\n", symb);
		exit( -1 );
	}
	if ( ( tree->tname = malloc( strlen( symb ) + 1 )) == 0)
	{
		fprintf(stderr, "Not enough memory for symbol: %s\n", symb);
		exit( -1 );
	}
	strcpy( tree->tname, symb );
	tree->tnext = tree->tright = tree->tleft = NULL;
	tree->symtype = flagtype;
	tree->module = mod_name;
	return( tree );
}

treenode *findsymb( tree, symb, flagtype )

treenode *tree;
char *symb;
int flagtype;

{
	int comptst, strcmp();
	
	while (1) {
		if (tree == NULL)
			return( NULL );
		if ( ((comptst = strcmp( tree->tname, symb )) == 0) &&
						(flagtype & tree->symtype) )
			return( tree );
		if (comptst < 0)
			tree = tree->tleft;
		else
			tree = tree->tright;
	}
}

int print_table( tree, flagtype )

treenode *tree;
int flagtype;

{
	register int total;
	
	if (tree == NULL)
		return( 0 );
	total = 0;
	total = print_table( tree->tleft, flagtype );
	total += print_sym( tree, flagtype );
	return( total + print_table( tree->tright, flagtype ) );
}

int print_sym( tree, flagtype )

treenode *tree;
int flagtype;

{
	treenode *findsymb(), *findsymb();
	register treenode *pos;
	int searchflag;
	register int i, printed;
	
	pos = tree;
	if (pos == NULL || ((pos->symtype & flagtype) == 0) )
	    return( 0 );

	printf( "%-14s", pos->tname );

	if ( !(pos->symtype & GLOBREF) )
	    printf("********  ");
	else {
	    printf( "%-10s", pos->module );
	    pos = pos->tnext;
	}

	printed = 0;
	while (pos != NULL) {
	    if ( printed % 5 == 0 && printed )
		printf("\n%-24s", " ");
	    printf( "%-10s", pos->module );
	    printed++;
	    pos = pos->tnext;
	}
	putchar('\n');
	return( 1 );
}
